/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.tnd.common.vie.ITndQuoteVerify;

public class TndQuoteVerifyPayment
implements ITndQuoteVerify {
    public void verifyData(PdsVieContext context) {
        long projectId = context.getProjectId();
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_paymanage");
        if (PdsFlowConfigUtils.existsSpecificNode((DynamicObject)billObj, (String)PdsBizNodeEnums.PAYMANAGE.getValue()) && !billObj.getString("billstatus").equals(BillStatusEnum.AUDIT.getVal())) {
            context.setVerify(false);
            context.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u9700\u8981\u7f34\u8d39\uff0c\u4f46\u7f34\u8d39\u7ba1\u7406\u672a\u5ba1\u6838\uff0c\u8bf7\u5148\u8054\u7cfb\u91c7\u8d2d\u65b9\u5ba1\u6838\u7f34\u8d39\u7ba1\u7406\u3002", (String)"TndQuoteVerifyPayment_0", (String)"scm-tnd-common", (Object[])new Object[0]));
            return;
        }
        String feeway = billObj.getString("feeway.number");
        if (null == feeway || "C020701".equals(feeway)) {
            context.setSucced(true);
            return;
        }
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("supplier", "=", (Object)context.getSupplierId());
        qfilters.and(new QFilter("paystatus", "=", (Object)PayStatusEnums.NOPAY.getValue()).or("paystatus", "=", (Object)PayStatusEnums.NOCONFIRM.getValue()));
        if (QueryServiceHelper.exists((String)"tnd_payment", (QFilter[])qfilters.toArray())) {
            context.setVerify(false);
            context.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u672a\u5b8c\u6210\u7f34\u8d39\uff0c\u8bf7\u5b8c\u6210\u7f34\u8d39\u540e\u518d\u53c2\u4e0e\u7ade\u4ef7\u3002", (String)"TndQuoteVerifyPayment_4", (String)"scm-tnd-common", (Object[])new Object[0]));
        }
    }
}

