/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.tnd.common.vie.ITndQuoteVerify;

public class TndQuoteVerifyVieRegion
implements ITndQuoteVerify {
    private static final long serialVersionUID = 1L;

    public void verifyData(PdsVieContext context) {
        String isRegionControl = context.getVieBillObj().getString("isregioncontrol");
        if (!"1".equals(isRegionControl)) {
            return;
        }
        DynamicObjectCollection purlistObjs = context.getView().getModel().getEntryEntity("entryentity");
        if (purlistObjs == null || purlistObjs.size() == 0) {
            return;
        }
        String valueField = this.getValueField(context);
        String valueFieldName = this.getValueFieldName(context);
        StringBuilder sb = new StringBuilder();
        int rowIndex = 0;
        for (DynamicObject purlistObj : purlistObjs) {
            if (!context.getSelectSrcentryIds().contains(purlistObj.getLong("srcentryid"))) {
                ++rowIndex;
                continue;
            }
            if (purlistObj.getBoolean("isdiscarded") || purlistObj.getBoolean("ispresent")) {
                ++rowIndex;
                continue;
            }
            BigDecimal value = purlistObj.getBigDecimal(valueField);
            BigDecimal valueFrom = purlistObj.getBigDecimal("viefrom");
            BigDecimal valueTo = purlistObj.getBigDecimal("vieto");
            if (valueFrom.compareTo(BigDecimal.ZERO) > 0 && value.compareTo(valueFrom) <= 0) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s(%3$s) \u5e94\u5927\u4e8e  %4$s;", (String)"TndQuoteVerifyVieRegion_10", (String)"scm-tnd-common", (Object[])new Object[0]), rowIndex + 1, valueFieldName, value.setScale(4, 5), valueFrom.setScale(4, 5)));
                sb.append("\n");
            }
            if (valueTo.compareTo(BigDecimal.ZERO) > 0 && value.compareTo(valueTo) >= 0) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s(%3$s) \u5e94\u5c0f\u4e8e  %4$s;", (String)"TndQuoteVerifyVieRegion_11", (String)"scm-tnd-common", (Object[])new Object[0]), rowIndex + 1, valueFieldName, value.setScale(4, 5), valueTo.setScale(4, 5)));
                sb.append("\n");
            }
            ++rowIndex;
        }
        if (sb.length() > 0) {
            context.setVerify(false);
            context.setMessage(sb.toString());
        }
    }

    private String getValueField(PdsVieContext context) {
        String viePattern = this.getViePattern(context);
        String valueField = null;
        switch (viePattern) {
            case "1": {
                if (context.getVieBillObj().getString("taxtype").equals("2")) {
                    valueField = "price";
                    break;
                }
                valueField = "taxprice";
                break;
            }
            case "2": {
                valueField = "vieratio";
                break;
            }
            case "3": {
                valueField = "viediffer";
                break;
            }
        }
        return valueField;
    }

    private String getValueFieldName(PdsVieContext context) {
        String viePattern = this.getViePattern(context);
        String valueFieldName = null;
        switch (viePattern) {
            case "1": {
                if (context.getVieBillObj().getString("taxtype").equals("2")) {
                    valueFieldName = ResManager.loadKDString((String)"\u672a\u7a0e\u5355\u4ef7", (String)"TndQuoteVerifyVieRegion_4", (String)"scm-tnd-common", (Object[])new Object[0]);
                    break;
                }
                valueFieldName = ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"TndQuoteVerifyVieRegion_5", (String)"scm-tnd-common", (Object[])new Object[0]);
                break;
            }
            case "2": {
                if (context.getVieBillObj().getString("vietype").equals("A")) {
                    valueFieldName = ResManager.loadKDString((String)"\u4e0b\u8c03\u6bd4\u7387", (String)"TndQuoteVerifyVieRegion_6", (String)"scm-tnd-common", (Object[])new Object[0]);
                    break;
                }
                valueFieldName = ResManager.loadKDString((String)"\u4e0a\u6d6e\u6bd4\u7387", (String)"TndQuoteVerifyVieRegion_7", (String)"scm-tnd-common", (Object[])new Object[0]);
                break;
            }
            case "3": {
                if (context.getVieBillObj().getString("vietype").equals("A")) {
                    valueFieldName = ResManager.loadKDString((String)"\u4e0b\u8c03\u4ef7\u5dee", (String)"TndQuoteVerifyVieRegion_8", (String)"scm-tnd-common", (Object[])new Object[0]);
                    break;
                }
                valueFieldName = ResManager.loadKDString((String)"\u4e0a\u6d6e\u4ef7\u5dee", (String)"TndQuoteVerifyVieRegion_9", (String)"scm-tnd-common", (Object[])new Object[0]);
                break;
            }
        }
        return valueFieldName;
    }

    private String getViePattern(PdsVieContext context) {
        String viePattern = context.getVieBillObj().getString("viepattern");
        if (StringUtils.isBlank((CharSequence)viePattern)) {
            viePattern = "1";
        }
        return viePattern;
    }
}

