/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.BizLog;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.SrcVieStatusEnums;
import kd.scm.pds.common.enums.VieTurnsEnums;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.tnd.common.vie.ITndVieInitContext;

public class TndVieInitContext
implements ITndVieInitContext {
    private static final long serialVersionUID = 1L;

    @Override
    public PdsVieContext createVieContext(IFormView view) {
        BizLog.log((String)"### PdsVieContext createVieContext start");
        PdsVieContext context = PdsVieHelper.getContextInstance();
        BizLog.log((String)("### PdsVieContext PdsVieContext start:" + context));
        context.setView(view);
        Map paraMap = context.getView().getFormShowParameter().getCustomParams();
        context.setProjectId(PdsCommonUtils.object2Long(paraMap.get("projectid")));
        context.setBillId(PdsCommonUtils.object2Long(paraMap.get("billid")));
        context.setSupplierId(PdsCommonUtils.object2Long(paraMap.get("supplierid")));
        context.setSupplierName(String.valueOf(paraMap.get("suppliername")));
        DynamicObject vieBillObj = PdsVieHelper.getVieBillObj((long)context.getProjectId());
        context.setVieBillObj(vieBillObj);
        context.setReduceType(vieBillObj.getString("reducetype"));
        context.setReducePct(vieBillObj.getBigDecimal("reducepct"));
        String viePattern = vieBillObj.getString("viepattern");
        context.setViePattern(StringUtils.isBlank((CharSequence)viePattern) ? "1" : viePattern);
        context.setBidName(context.getVieBillObj().getString("bidname"));
        context.setOrgId(context.getVieBillObj().getLong("org.id"));
        context.setLocCurrencyId(context.getVieBillObj().getLong("currency.id"));
        String turns = String.valueOf(paraMap.get("turns"));
        context.setTurns(turns);
        DynamicObject vieTurnsObj = PdsVieHelper.getLastVieTurnsObj((DynamicObject)context.getVieBillObj(), (String)turns);
        if (vieTurnsObj != null) {
            context.setVieturns(vieTurnsObj.getString("vieturns"));
            context.setBidStatus(vieTurnsObj.getString("turnsbidstatus"));
        } else {
            context.setVieturns(VieTurnsEnums.VIE01.getValue());
            String bidStatus = context.getVieBillObj().getString("bidstatus");
            if (StringUtils.isBlank((CharSequence)bidStatus)) {
                context.setBidStatus(SrcVieStatusEnums.BEENEXAMINED.getValue());
            } else {
                context.setBidStatus(bidStatus);
            }
        }
        context.setVieTechScheme("1");
        context.setSrcRefreshTimes(context.getView().getModel().getDataEntity().getInt("srcrefreshtimes"));
        context.setTndRefreshTimes(context.getView().getModel().getDataEntity().getInt("tndrefreshtimes"));
        context.setAutoSaveTimes(context.getView().getModel().getDataEntity().getInt("autosavetimes"));
        context.setSubmitType(context.getView().getModel().getDataEntity().getString("submittype"));
        Object vie_purlist = vieBillObj.get("vie_purlist");
        if (StringUtils.isBlank((Object)vie_purlist)) {
            vie_purlist = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"vie_purlist");
        }
        if (!Objects.isNull(vie_purlist)) {
            context.setVie_purlist(vie_purlist.toString());
        } else {
            context.setVie_purlist("3");
        }
        boolean isNotifySupplier = PdsCommonUtils.object2Boolean((Object)ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isnotify"));
        context.setNotifySupplier(isNotifySupplier);
        this.setBidCountByTurns(context);
        this.setBidCountType(context);
        List extProperties = PdsCommonUtils.getPropertiesFromFieldMapper((String)"src_vie_detailf7", (String)"src_purlistf7");
        context.setExtProperties(extProperties);
        BizLog.log((String)("### PdsVieContext createVieContext end:" + context.getTurns()));
        return context;
    }

    private void setBidCountByTurns(PdsVieContext context) {
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj().getDynamicObject("srctype"));
        boolean isBidCountByTurns = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isbidcountbyturns", (Object)true, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj())));
        context.setBidCountByTurns(isBidCountByTurns);
    }

    private void setBidCountType(PdsVieContext context) {
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj().getDynamicObject("srctype"));
        String bidCountType = PdsCommonUtils.object2String((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isbidcounttype", (Object)"1", (long)SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj())), (String)"1");
        if ("1".equals(bidCountType)) {
            context.setBidCountType("project");
        } else if ("2".equals(bidCountType)) {
            context.setBidCountType("package");
        } else if ("3".equals(bidCountType)) {
            context.setBidCountType("purlist");
        }
    }
}

