/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.webapi.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.util.TndQuoteUtil;
import kd.scm.tnd.common.util.TndCompConfigUtil;
import kd.scm.tnd.webapi.model.TndBidDocEntryModel;
import kd.scm.tnd.webapi.model.TndTenderModelV2;
import kd.scm.tnd.webapi.util.TndPurListUtil;

@ApiController(value="tnd", desc="\u6295\u6807\u5355")
@ApiMapping(value="tnd_tenderbill")
public class TndTenderBillControllerV2
implements Serializable {
    private static final long serialVersionUID = 515772134612936900L;

    @ApiPostMapping(value="save/v2")
    public CustomApiResult<String> save(@ApiParam(value="\u6295\u6807\u5355\u6a21\u578b") @ApiParam(value="\u6295\u6807\u5355\u6a21\u578b") TndTenderModelV2 tenderModel) {
        return this.doOperation(tenderModel, "save");
    }

    @ApiPostMapping(value="quote/v2")
    public CustomApiResult<String> quote(@ApiParam(value="\u6295\u6807\u5355\u6a21\u578b") @ApiParam(value="\u6295\u6807\u5355\u6a21\u578b") TndTenderModelV2 tenderModel) {
        return this.doOperation(tenderModel, "audit");
    }

    private CustomApiResult<String> doOperation(TndTenderModelV2 tenderModel, String operation) {
        StringBuilder msgBuilder = new StringBuilder();
        TndPurListUtil.validateData(tenderModel.getId(), this.getEntityKey(), msgBuilder);
        if (msgBuilder.length() > 0) {
            return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
        }
        TndPurListUtil.checkPermission(tenderModel.getId(), this.getEntityKey(), operation, msgBuilder);
        if (msgBuilder.length() > 0) {
            return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
        }
        Long quoteId = tenderModel.getId();
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(quoteId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)quoteId, (String)this.getEntityKey());
        this.validateConfirm(obj, msgBuilder);
        if (msgBuilder.length() > 0) {
            return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
        }
        DynamicObject bidDocCompObj = TemplateUtil.getCompData((DynamicObject)obj, (String)"src_biddoc_tnd");
        if (null != bidDocCompObj) {
            this.updateDocComponent(obj, bidDocCompObj, tenderModel.getBidDocAttEntry(), msgBuilder);
            if (msgBuilder.length() > 0) {
                return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidDocCompObj});
        }
        DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)"src_purlist_stand");
        TndPurListUtil.updateComponentV2(obj, compObj, tenderModel.getPurListEntry(), msgBuilder);
        if (msgBuilder.length() > 0) {
            return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
        }
        Cal4DynamicObj.calByQty((DynamicObject)compObj, (String)"entryentity");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{compObj});
        switch (operation) {
            case "save": {
                break;
            }
            case "audit": {
                if (null != bidDocCompObj) {
                    this.validateCompConfig(obj, bidDocCompObj, msgBuilder);
                    if (msgBuilder.length() > 0) {
                        return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
                    }
                    this.bidDocValid(obj, bidDocCompObj, msgBuilder);
                    if (msgBuilder.length() > 0) {
                        return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
                    }
                    ArrayList<Long> bidDocIDList = new ArrayList<Long>();
                    bidDocIDList.add(bidDocCompObj.getLong("id"));
                    TndPurListUtil.invokeOp(bidDocIDList, "src_biddoc_tnd", "submit", msgBuilder);
                    if (msgBuilder.length() > 0) {
                        return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
                    }
                }
                this.validateCompConfig(obj, compObj, msgBuilder);
                if (msgBuilder.length() <= 0) break;
                return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
            }
        }
        TndQuoteUtil.calcTotalAmount((String)this.getEntityKey(), (long)quoteId);
        this.invokeOp(idList, this.getEntityKey(), operation, msgBuilder);
        if (msgBuilder.length() > 0) {
            return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
        }
        if ("audit".equals(operation)) {
            this.updateEntryStatus(compObj, operation);
        }
        return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"TndTenderBillControllerV2_0", (String)"scm-tnd-webapi", (Object[])new Object[0]));
    }

    private void updateDocComponent(DynamicObject obj, DynamicObject compObj, List<TndBidDocEntryModel> entryList, StringBuilder msgBuilder) {
        if (null == entryList) {
            return;
        }
        DynamicObjectCollection cols = compObj.getDynamicObjectCollection("entryentity");
        Map entryIdColMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)cols, (String)"id");
        for (TndBidDocEntryModel entryModel : entryList) {
            Long entryId = entryModel.getId();
            DynamicObject col = (DynamicObject)entryIdColMap.get(String.valueOf(entryId));
            if (Objects.isNull(col)) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e%s\u4e0d\u5b58\u5728", (String)"TndTenderBillControllerV2_1", (String)"scm-tnd-webapi", (Object[])new Object[0]), entryId)).append(";");
                continue;
            }
            col.set("packnote", (Object)entryModel.getNote());
            Long[] bidDocAttchIdArr = entryModel.getBidDocAttchId();
            DynamicObjectCollection bidAttchCols = col.getDynamicObjectCollection("bidattach");
            bidAttchCols.clear();
            if (bidDocAttchIdArr.length > 0) {
                col.set("packfilename", (Object)entryModel.getFilename());
                for (Long bidDocId : bidDocAttchIdArr) {
                    DynamicObject newEntry = bidAttchCols.addNew();
                    newEntry.set("fbasedataid", (Object)bidDocId);
                }
                continue;
            }
            col.set("packfilename", (Object)"");
        }
    }

    private void updateEntryStatus(DynamicObject compObj, String operation) {
        String entryStatus = "A";
        switch (operation) {
            case "audit": {
                entryStatus = "B";
                break;
            }
        }
        DynamicObjectCollection cols = compObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject col : cols) {
            col.set("entrystatus", (Object)entryStatus);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{compObj});
    }

    private void validateConfirm(DynamicObject billObj, StringBuilder validateMsg) {
        Long projectId = billObj.getLong("project.id");
        QFilter filter = new QFilter("billid", "=", (Object)projectId).and("isconfirm", "=", (Object)Boolean.TRUE);
        Long supId = billObj.getLong("supplier.id");
        String supType = SupplierUtil.getSupType(null);
        String filterSupPro = SupplierUtil.getSupProBySupType((String)supType);
        filter.and(filterSupPro, "=", (Object)supId);
        if (!QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])new QFilter[]{filter})) {
            validateMsg.append(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u672a\u786e\u8ba4\uff0c\u4e0d\u80fd\u6295\u6807\u3002", (String)"TndTenderBillControllerV2_2", (String)"scm-tnd-webapi", (Object[])new Object[0]));
        }
    }

    private void validateCompConfig(DynamicObject billObj, DynamicObject compObj, StringBuilder validateMsg) {
        TndCompConfigUtil.validateCompConfig((DynamicObject)billObj, (DynamicObject)compObj, (StringBuilder)validateMsg);
    }

    private void invokeOp(List<Long> idList, String entityKey, String opreate, StringBuilder validateMsg) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        OperationResult result = OperationServiceHelper.executeOperate((String)opreate, (String)entityKey, (Object[])idList.toArray(), (OperateOption)option);
        if (result == null || !result.isSuccess()) {
            String message;
            String string = message = result == null ? null : ExceptionUtil.getErrorInfoDetails((List)result.getAllErrorOrValidateInfo());
            if (StringUtils.isEmpty((CharSequence)message)) {
                message = ResManager.loadKDString((String)"\u6295\u6807\u5355\u6267\u884c\u64cd\u4f5c\u5931\u8d25", (String)"TndTenderBillControllerV2_3", (String)"scm-tnd-webapi", (Object[])new Object[0]);
            }
            validateMsg.append(message);
        }
    }

    private void bidDocValid(DynamicObject billObj, DynamicObject compObj, StringBuilder validateMsg) {
        Boolean isneedbiddoc = billObj.getBoolean("isneedbiddoc");
        if (isneedbiddoc.booleanValue()) {
            return;
        }
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        int index = 1;
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : rows) {
            if (row.getBoolean("isneedbiddoc") && row.getString("packfilename").length() == 0) {
                String entryStatus = row.getString("entrystatus");
                if (Objects.equals(entryStatus, ProjectStatusEnums.INVALID.getValue())) {
                    ++index;
                    continue;
                }
                sb = sb.length() == 0 ? sb.append(index) : sb.append(',').append(index);
            }
            ++index;
        }
        if (sb.length() > 0) {
            validateMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u9700\u8981\u4e0a\u4f20\u6807\u4e66\uff0c\u8bf7\u4e0a\u4f20\u540e\u64cd\u4f5c\u3002", (String)"TndTenderBillControllerV2_4", (String)"scm-tnd-webapi", (Object[])new Object[0]), sb));
        }
    }

    private String getEntityKey() {
        return "tnd_tenderbill";
    }
}

