/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.webapi.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.pds.common.util.CheckPermission4OrgUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.tnd.common.util.TndCompConfigUtil;
import kd.scm.tnd.webapi.model.TndPurListEntryModel;
import kd.scm.tnd.webapi.model.TndPurListEntryModelV2;

public class TndPurListUtil {
    public static void updateComponent(DynamicObject obj, DynamicObject compObj, List<TndPurListEntryModel> entryList, StringBuilder msgBuilder) {
        compObj.set("origin", (Object)"2");
        compObj.set("pentitykey", (Object)obj.getDataEntityType().getName());
        DynamicObjectCollection cols = compObj.getDynamicObjectCollection("entryentity");
        Map entryIdColMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)cols, (String)"id");
        for (TndPurListEntryModel entryModel : entryList) {
            Long entryId = entryModel.getId();
            DynamicObject col = (DynamicObject)entryIdColMap.get(String.valueOf(entryId));
            if (Objects.isNull(col)) {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e%s\u4e0d\u5b58\u5728", (String)"TndPurListUtil_0", (String)"scm-tnd-webapi", (Object[])new Object[0]), entryId)).append(";");
                continue;
            }
            col.set("price", (Object)entryModel.getPrice());
            col.set("taxprice", (Object)entryModel.getTaxprice());
            col.set("amount", (Object)entryModel.getAmount());
            col.set("taxamount", (Object)entryModel.getTaxamount());
            col.set("currency", (Object)entryModel.getCurrencyId());
            col.set("currency_id", (Object)entryModel.getCurrencyId());
            col.set("taxitem", (Object)entryModel.getTaxItemId());
            col.set("taxitem_id", (Object)entryModel.getTaxItemId());
            col.set("taxrate", (Object)entryModel.getTaxRate());
            col.set("note", (Object)entryModel.getNote());
            col.set("entryparentid", (Object)String.valueOf(obj.getPkValue()));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void updateComponentV2(DynamicObject obj, DynamicObject compObj, List<TndPurListEntryModelV2> entryList, StringBuilder msgBuilder) {
        compObj.set("origin", (Object)"2");
        compObj.set("pentitykey", (Object)obj.getDataEntityType().getName());
        cols = compObj.getDynamicObjectCollection("entryentity");
        notNewPurListIdColMap = TndPurListUtil.getNotNewPurlistIdColMap(cols);
        entryIdColMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)cols, (String)"id");
        hasMatchedEntryId = new HashSet<String>(8);
        hasNewData = false;
        for (TndPurListEntryModelV2 entryModel : entryList) {
            entryId = entryModel.getId();
            col = (DynamicObject)entryIdColMap.get(String.valueOf(entryId));
            isAddNew = false;
            if (!Objects.isNull(col)) ** GOTO lbl48
            isNew = entryModel.isIsnew();
            if (isNew) {
                isAdd = obj.getBoolean("isadd");
                if (!isAdd) {
                    msgBuilder.append(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u4e0d\u5141\u8bb8\u65b0\u589e\u6807\u7684\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e;", (String)"TndPurListUtil_1", (String)"scm-tnd-webapi", (Object[])new Object[0]));
                    continue;
                }
                srcCol = null;
                srcEntryId /* !! */  = null;
                customPro = entryModel.getCustomPro();
                if (StringUtils.isNotBlank((CharSequence)customPro)) {
                    try {
                        mapList = (Map)JacksonJsonUtil.fromJSON((String)customPro, Map.class);
                        srcEntryId /* !! */  = mapList.get("srcentryid");
                        srcCol = (DynamicObject)entryIdColMap.get(String.valueOf(srcEntryId /* !! */ ));
                    }
                    catch (Throwable e) {
                        throw new KDBizException("covert json exception->" + e.getMessage());
                    }
                }
                if (null == srcCol) {
                    srcEntryId /* !! */  = entryModel.getPurlistid();
                    srcCol = notNewPurListIdColMap.get(String.valueOf(srcEntryId /* !! */ ));
                }
                if (null == srcCol) {
                    msgBuilder.append(String.format(ResManager.loadKDString((String)"\u590d\u5236\u884c\u7684\u6e90\u5355\u5206\u5f55id\uff1a%s\u4e0d\u5b58\u5728", (String)"TndPurListUtil_12", (String)"scm-tnd-webapi", (Object[])new Object[0]), new Object[]{srcEntryId /* !! */ })).append(";");
                    continue;
                }
                newcol = cols.addNew();
                DynamicObjectUtils.copy((DynamicObject)srcCol, (DynamicObject)newcol, TndPurListUtil.getIgnoreKeys());
                newcol.set("isnew", (Object)true);
                hasNewData = true;
                isAddNew = true;
                col = newcol;
            } else {
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e%s\u4e0d\u5b58\u5728", (String)"TndPurListUtil_0", (String)"scm-tnd-webapi", (Object[])new Object[0]), new Object[]{entryId})).append(";");
                continue;
lbl48:
                // 1 sources

                hasMatchedEntryId.add(String.valueOf(entryId));
                isNew = entryModel.isIsnew();
                if (isNew) {
                    isAddNew = true;
                }
            }
            if (isAddNew) {
                col.set("materialnane", (Object)entryModel.getMaterialname());
                col.set("description", (Object)entryModel.getDescription());
                col.set("materialmodel", (Object)entryModel.getModel());
                col.set("brand", (Object)entryModel.getBrand());
            }
            col.set("price", (Object)entryModel.getPrice());
            col.set("taxprice", (Object)entryModel.getTaxprice());
            col.set("amount", (Object)entryModel.getAmount());
            col.set("taxamount", (Object)entryModel.getTaxamount());
            col.set("currency", (Object)entryModel.getCurrencyId());
            col.set("currency_id", (Object)entryModel.getCurrencyId());
            col.set("taxitem", (Object)entryModel.getTaxItemId());
            col.set("taxitem_id", (Object)entryModel.getTaxItemId());
            col.set("taxrate", (Object)entryModel.getTaxRate());
            col.set("note", (Object)entryModel.getNote());
            col.set("entryparentid", (Object)String.valueOf(obj.getPkValue()));
            supAttchCols = col.getDynamicObjectCollection("purlistentry_supfj");
            supAttchCols.clear();
            if (supAttchCols.size() < 0 || null == (attachIds = entryModel.getSupAttchId())) continue;
            for (Long attachId : attachIds) {
                newEntry = supAttchCols.addNew();
                newEntry.set("fbasedataid", (Object)attachId);
            }
        }
        needDelCol = TndPurListUtil.getNeedDelCol(entryIdColMap, hasMatchedEntryId);
        cols.removeAll(needDelCol);
        if (hasNewData) {
            DynamicObjectUtil.setBillEntrySeq((DynamicObject)compObj, (String)"entryentity");
        }
    }

    public static Map<String, DynamicObject> getNotNewPurlistIdColMap(DynamicObjectCollection cols) {
        HashMap<String, DynamicObject> notNewPurListIdColMap = new HashMap<String, DynamicObject>(cols.size());
        for (DynamicObject col : cols) {
            boolean isNew = col.getBoolean("isnew");
            if (isNew) continue;
            notNewPurListIdColMap.put(String.valueOf(col.getLong("purlist.id")), col);
        }
        return notNewPurListIdColMap;
    }

    public static List<DynamicObject> getNeedDelCol(Map<String, DynamicObject> notNewPurListIdColMap, Set<String> hasMatchedEntryId) {
        ArrayList<DynamicObject> needDelCol = new ArrayList<DynamicObject>(notNewPurListIdColMap.size());
        for (Map.Entry<String, DynamicObject> notNewPurListIdColEntry : notNewPurListIdColMap.entrySet()) {
            boolean isNew;
            if (hasMatchedEntryId.contains(notNewPurListIdColEntry.getKey()) || !(isNew = notNewPurListIdColEntry.getValue().getBoolean("isnew"))) continue;
            needDelCol.add(notNewPurListIdColEntry.getValue());
        }
        return needDelCol;
    }

    public static Set<String> getIgnoreKeys() {
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("seq");
        ignoreKeys.add("purlistseq");
        ignoreKeys.add("purlistentry_fj");
        ignoreKeys.add("purlistentry_supfj");
        return ignoreKeys;
    }

    public static void validateConfirm(DynamicObject billObj, StringBuilder validateMsg) {
        Long projectId = billObj.getLong("project.id");
        QFilter filter = new QFilter("billid", "=", (Object)projectId).and("isconfirm", "=", (Object)Boolean.TRUE);
        Long supId = billObj.getLong("supplier.id");
        String supType = SupplierUtil.getSupType(null);
        String filterSupPro = SupplierUtil.getSupProBySupType((String)supType);
        filter.and(filterSupPro, "=", (Object)supId);
        if (!QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])new QFilter[]{filter})) {
            validateMsg.append(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u672a\u786e\u8ba4\uff0c\u4e0d\u80fd\u62a5\u4ef7\u3002", (String)"TndPurListUtil_3", (String)"scm-tnd-webapi", (Object[])new Object[0]));
        }
    }

    public static void validateCompConfig(DynamicObject billObj, DynamicObject compObj, StringBuilder validateMsg) {
        TndCompConfigUtil.validateCompConfig((DynamicObject)billObj, (DynamicObject)compObj, (StringBuilder)validateMsg);
    }

    public static void invokeOp(List<Long> idList, String entityKey, String opreate, StringBuilder validateMsg) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)opreate, (String)entityKey, (Object[])idList.toArray(), (OperateOption)option);
        if (result == null || !result.isSuccess()) {
            String message;
            String string = message = result == null ? null : ExceptionUtil.getErrorInfoDetails((List)result.getAllErrorOrValidateInfo());
            if (StringUtils.isEmpty((CharSequence)message)) {
                message = ResManager.loadKDString((String)"\u5355\u636e\u6267\u884c\u64cd\u4f5c\u5931\u8d25", (String)"TndPurListUtil_4", (String)"scm-tnd-webapi", (Object[])new Object[0]);
            }
            validateMsg.append(message);
        }
    }

    public static void checkPermission(Long id, String entityKey, String operation, StringBuilder msgBuilder) {
        String permItemId = "";
        String operationName = "";
        switch (operation) {
            case "save": {
                permItemId = "4715a0df000000ac";
                operationName = ResManager.loadKDString((String)"\u4fee\u6539", (String)"TndPurListUtil_5", (String)"scm-tnd-webapi", (Object[])new Object[0]);
                break;
            }
            case "audit": {
                permItemId = "47162f66000000ac";
                operationName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"TndPurListUtil_6", (String)"scm-tnd-webapi", (Object[])new Object[0]);
                break;
            }
            case "unaudit": {
                permItemId = "47165e8e000000ac";
                operationName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"TndPurListUtil_7", (String)"scm-tnd-webapi", (Object[])new Object[0]);
                break;
            }
        }
        boolean hasPermission = CheckPermission4OrgUtils.checkPermission4Org((String)entityKey, (String)String.valueOf(id), (String)permItemId, (String)"0DUMFA=HL9S1");
        if (!hasPermission) {
            msgBuilder.append(String.format(ResManager.loadKDString((String)"\u65e0\u201c\u6295\u6807\u5355\u201d\u7684\u201c%s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TndPurListUtil_8", (String)"scm-tnd-webapi", (Object[])new Object[0]), operationName));
        }
    }

    public static void validateData(Long quoteId, String entityKey, StringBuilder msgBuilder) {
        if (quoteId.intValue() == 0) {
            msgBuilder.append(ResManager.loadKDString((String)"\u4f20\u5165\u5355\u636eid\u4e3a0", (String)"TndPurListUtil_9", (String)"scm-tnd-webapi", (Object[])new Object[0]));
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)quoteId, (String)entityKey);
        if (Objects.isNull(obj)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u5355\u636e\u672a\u627e\u5230", (String)"TndPurListUtil_10", (String)"scm-tnd-webapi", (Object[])new Object[0]));
            return;
        }
        DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)"src_purlist_stand");
        if (Objects.isNull(compObj)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u901a\u7528\u62a5\u4ef7\u5355\u6570\u636e\u4e3a\u7a7a", (String)"TndPurListUtil_11", (String)"scm-tnd-webapi", (Object[])new Object[0]));
            return;
        }
    }
}

