/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.tndaudit.ITndBillAfterAuditHandler;
import kd.scm.pds.common.tndaudit.ITndBillAuditHandler;
import kd.scm.pds.common.tndaudit.TndBillAuditContext;

public class TndTenderQuoteBillAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List fields = args.getFieldKeys();
        fields.add("project");
        fields.add("suppliertype");
        fields.add("supplier");
        fields.add("opentype");
        fields.add("template");
        fields.add("supplierip");
        fields.add("iscompete");
        fields.add("isfinish");
        fields.add("turns");
        fields.add("bizstatus");
        fields.add("billdate");
        fields.add("deadline");
        fields.add("istender");
        fields.add("isquote");
        fields.add("isneedbiddoc");
        fields.add("ispuragent");
        fields.add("tplentry");
        fields.add("number");
        fields.add("tplentry.tmp_component");
        fields.add("tplentry.tmp_bizobject");
        fields.add("tplentry.tmp_template");
        fields.add("tplentry.srctplid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] billObjs;
        for (DynamicObject billObj : billObjs = args.getDataEntities()) {
            TndBillAuditContext context = new TndBillAuditContext();
            context.setBillObj(billObj);
            context.setOperationKey(args.getOperationKey());
            this.doAuditOperation(context);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] billObjs;
        for (DynamicObject billObj : billObjs = args.getDataEntities()) {
            ExtPluginContext context = new ExtPluginContext();
            String openType = null;
            openType = "tnd_quotebill".equals(billObj.getDataEntityType().getName()) ? billObj.getString("opentype") : billObj.getString("project.opentype");
            if ("9".equals(openType)) {
                context.setEntityId("src_compare");
            }
            context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("project")));
            context.setBillObj(billObj);
            context.setOperationKey(args.getOperationKey());
            this.afterAuditHandle(context);
        }
    }

    private void doAuditOperation(TndBillAuditContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndBillAuditHandler.class.getSimpleName(), null);
        for (ITndBillAuditHandler handler : handlers) {
            handler.process(context);
        }
    }

    private void afterAuditHandle(ExtPluginContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndBillAfterAuditHandler.class.getSimpleName(), null);
        for (IExtPluginHandler handler : handlers) {
            handler.process(context);
        }
    }
}

