/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.audithandle;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.tndaudit.ITndBillAuditHandler;
import kd.scm.pds.common.tndaudit.TndBillAuditContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class TndBillBidDocHandler
implements ITndBillAuditHandler {
    private static final long serialVersionUID = 1L;

    public void process(TndBillAuditContext context) {
        if (context.getEntityName().equals("tnd_tenderbill")) {
            this.handleBidDoc(context);
        }
    }

    protected void handleBidDoc(TndBillAuditContext context) {
        QFilter qfilter = TemplateUtil.getComponentQfilter((Object)String.valueOf(context.getBillId()), (String)context.getEntityName(), (String)"src_biddoc_tnd");
        DynamicObject compObj = BusinessDataServiceHelper.loadSingle((String)"src_biddoc_tnd", (String)"id", (QFilter[])qfilter.toArray());
        if (compObj == null) {
            return;
        }
        long compId = PdsCommonUtils.object2Long((Object)compObj.getPkValue());
        QFilter docFilter = new QFilter("billid", "=", (Object)compId);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_biddoctplf7", (String)"suppliertype,supplier,project,package,entrystatus,supplierip,turns,billdate", (QFilter[])docFilter.toArray());
        if (rows == null || rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            row.set("project", (Object)context.getProjectId());
            row.set("suppliertype", (Object)context.getSuppliertype());
            row.set("supplier", (Object)context.getSupplierId());
            String entryStatus = row.getString("entrystatus");
            if (Objects.equals(entryStatus, ProjectStatusEnums.INVALID.getValue())) continue;
            if (context.isAudit()) {
                if (context.getOpenType().equals("9")) {
                    row.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
                } else {
                    row.set("entrystatus", (Object)ProjectStatusEnums.QUOTED.getValue());
                }
                row.set("billdate", context.getBillObj().get("billdate"));
                row.set("supplierip", context.getBillObj().get("supplierip"));
                row.set("turns", (Object)QuoteTurnsEnums.NEGOTIATE00.getValue());
                continue;
            }
            row.set("entrystatus", (Object)ProjectStatusEnums.TOQUOTE.getValue());
            row.set("billdate", null);
            row.set("supplierip", null);
            row.set("turns", null);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }
}

