/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.audithandle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.tndaudit.ITndBillAuditHandler;
import kd.scm.pds.common.tndaudit.TndBillAuditContext;
import kd.scm.pds.common.util.PdsCommonUtils;

public class TndBillOtherPurlistHandler
implements ITndBillAuditHandler {
    private static final long serialVersionUID = 1L;

    public void process(TndBillAuditContext context) {
        if (!context.getOpenType().equals("9")) {
            return;
        }
        if (context.isAudit()) {
            this.otherPurlistHandle(context, ProjectStatusEnums.OPENED.getValue(), ProjectStatusEnums.CLOSED.getValue());
        } else {
            this.otherPurlistHandle(context, ProjectStatusEnums.CLOSED.getValue(), ProjectStatusEnums.OPENED.getValue());
        }
    }

    protected void otherPurlistHandle(TndBillAuditContext context, String preStatus, String newStatus) {
        QFilter qfilter = this.getBaseFilter(context);
        qfilter.and("entrystatus", "=", (Object)preStatus);
        String orderBy = "purlist.id, turns desc";
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"purlist.id,entrystatus", (QFilter[])qfilter.toArray(), (String)orderBy);
        if (rows == null || rows.length == 0) {
            return;
        }
        Map<Long, DynamicObject> purlistMap = Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("purlist.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        ArrayList<DynamicObject> purlsitObjs = new ArrayList<DynamicObject>(purlistMap.size());
        for (Map.Entry<Long, DynamicObject> entry : purlistMap.entrySet()) {
            DynamicObject purlsitObj = entry.getValue();
            if (null == purlsitObj) continue;
            purlsitObj.set("entrystatus", (Object)newStatus);
            purlsitObjs.add(purlsitObj);
        }
        PdsCommonUtils.saveDynamicObjects(purlsitObjs);
    }

    protected QFilter getBaseFilter(TndBillAuditContext context) {
        QFilter qfilter = new QFilter("supplier", "=", (Object)context.getSupplierId());
        qfilter.and("purlist", "in", (Object)context.getPurlistIds());
        qfilter.and("id", "not in", (Object)context.getEntryIds());
        return qfilter;
    }
}

