/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.audithandle;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.tndaudit.ITndBillAuditHandler;
import kd.scm.pds.common.tndaudit.TndBillAuditContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCostDetailUtils;

public class TndBillPurlistHandler
implements ITndBillAuditHandler {
    private static final long serialVersionUID = 1L;

    public void process(TndBillAuditContext context) {
        this.handlePurlist(context);
    }

    protected void handlePurlist(TndBillAuditContext context) {
        QFilter qfilter = new QFilter("id", "in", (Object)context.getEntryIds());
        qfilter.and("entrystatus", "!=", (Object)ProjectStatusEnums.INVALID.getValue());
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"quotedate,entrystatus,isdiscarded", (QFilter[])qfilter.toArray());
        if (rows == null || rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            boolean isdiscarded = row.getBoolean("isdiscarded");
            if (isdiscarded) {
                row.set("entrystatus", (Object)ProjectStatusEnums.DISCARDED.getValue());
                continue;
            }
            if (context.isAudit()) {
                row.set("quotedate", (Object)TimeServiceHelper.now());
                if (context.getOpenType().equals("9")) {
                    row.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
                    continue;
                }
                row.set("entrystatus", (Object)ProjectStatusEnums.QUOTED.getValue());
                continue;
            }
            row.set("quotedate", null);
            row.set("entrystatus", (Object)ProjectStatusEnums.TOQUOTE.getValue());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
        PdsCostDetailUtils.handleCostDetail((String)"tnd_costdetail", (DynamicObject[])rows, (boolean)context.isAudit());
    }
}

