/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.audithandle;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.tndaudit.ITndBillAuditHandler;
import kd.scm.pds.common.tndaudit.TndBillAuditContext;
import kd.scm.pds.common.util.PdsCommonUtils;

public class TndBillTenderHandler
implements ITndBillAuditHandler {
    private static final long serialVersionUID = 1L;

    public void process(TndBillAuditContext context) {
        this.updateTenderStatus(context, "src_supplierinvite");
        this.updateTenderStatus(context, "src_bidopensupplier");
    }

    protected void updateTenderStatus(TndBillAuditContext context, String entityName) {
        QFilter tenderQFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        tenderQFilter.and("supplier", "=", (Object)context.getSupplierId());
        tenderQFilter.and("isdiscard", "=", (Object)"0");
        if (context.isMultipackage()) {
            tenderQFilter.and("package", "in", (Object)context.getPackageIds());
        }
        String billType = context.getBillObj().getDataEntityType().getName();
        boolean isQuoteBill = "tnd_quotebill".equals(billType);
        DynamicObject[] tenderRows = null;
        int count = 0;
        Map attachMap = null;
        if (entityName.equals("src_bidopensupplier")) {
            tenderRows = BusinessDataServiceHelper.load((String)entityName, (String)"isquote,istender,isnegotiate,supplierip,count,count2,bidder,supplier,package,isaptitude,aptitudenote", (QFilter[])new QFilter[]{tenderQFilter});
            count = AttachmentUtils.getBillAttachCount((String)billType, (long)context.getProjectId(), (long)context.getSupplierId(), null);
            attachMap = AttachmentUtils.getPurlistAttachCount((long)context.getProjectId(), (long)context.getSupplierId(), (long)0L, (String)"purlistentry_supfj");
        } else {
            tenderRows = BusinessDataServiceHelper.load((String)entityName, (String)"isquote,istender,isnegotiate,supplierip,isaptitude,aptitudenote", (QFilter[])new QFilter[]{tenderQFilter});
        }
        if (tenderRows == null || tenderRows.length == 0) {
            return;
        }
        for (DynamicObject tenderRow : tenderRows) {
            tenderRow.set("istender", (Object)context.isAudit());
            tenderRow.set("isquote", (Object)context.isAudit());
            if (entityName.equals("src_bidopensupplier")) {
                tenderRow.set("bidder", (Object)RequestContext.get().getCurrUserId());
                tenderRow.set("count", (Object)count);
                String key = tenderRow.getString("supplier.id") + '_' + tenderRow.getString("package.id");
                if (null != attachMap) {
                    tenderRow.set("count2", (Object)(attachMap.get(key) == null ? Integer.valueOf(0) : (Integer)attachMap.get(key)));
                }
            }
            if (context.isAudit()) {
                tenderRow.set("supplierip", (Object)PdsCommonUtils.getLoginIp());
            } else {
                tenderRow.set("supplierip", null);
                tenderRow.set("isaptitude", null);
                tenderRow.set("aptitudenote", null);
            }
            if (!isQuoteBill || QuoteTurnsEnums.NEGOTIATE00.getValue().equals(context.getTurns())) continue;
            tenderRow.set("isnegotiate", (Object)context.isAudit());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])tenderRows);
    }
}

