/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.validator;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class TndPayStatusValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObjectCollection rows;
        context.setSucced(true);
        if (context.getBillObj().getDataEntityType().getName().equals("tnd_apply")) {
            return;
        }
        if (PdsCommonUtils.object2Long((Object)context.getBillObj().getPkValue()) == 0L) {
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)context.getBillObj().getPkValue(), (String)context.getBillObj().getDataEntityType().getName());
        DynamicObject projectObj = obj.getDynamicObject("project");
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)projectObj);
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_paymanage");
        if (PdsFlowConfigUtils.existsSpecificNode((DynamicObject)billObj, (String)PdsBizNodeEnums.PAYMANAGE.getValue()) && !billObj.getString("billstatus").equals(BillStatusEnum.AUDIT.getVal())) {
            context.setSucced(false);
            context.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u9700\u8981\u7f34\u8d39\uff0c\u4f46\u7f34\u8d39\u7ba1\u7406\u672a\u5ba1\u6838\uff0c\u8bf7\u5148\u8054\u7cfb\u91c7\u8d2d\u65b9\u5ba1\u6838\u7f34\u8d39\u7ba1\u7406\u3002", (String)"TndPayStatusValidator_8", (String)"scm-tnd-opplugin", (Object[])new Object[0]));
            return;
        }
        String feeway = projectObj.getString("feeway.number");
        if (null == feeway || "C020701".equals(feeway)) {
            context.setSucced(true);
            return;
        }
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("supplier"));
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("supplier", "=", (Object)supplierId);
        Set statusSet = PdsCommonUtils.buildSet((String[])new String[]{PayStatusEnums.NOPAY.getValue(), PayStatusEnums.NOCONFIRM.getValue(), PayStatusEnums.DISCARDED.getValue(), PayStatusEnums.TERMINATED.getValue()});
        qfilters.and("paystatus", "in", (Object)statusSet);
        if ("biddoc".equals(context.getOperation())) {
            qfilters.and("packfeeitem", "=", (Object)Long.parseLong("775219867547625472"));
        }
        if (null != (rows = QueryServiceHelper.query((String)"tnd_payment", (String)"paystatus,package.id", (QFilter[])qfilters.toArray())) && rows.size() > 0) {
            if (rows.stream().anyMatch(e -> e.getString("paystatus").equals(PayStatusEnums.NOPAY.getValue()) || e.getString("paystatus").equals(PayStatusEnums.NOCONFIRM.getValue()))) {
                context.setSucced(false);
                if ("biddoc".equals(context.getOperation())) {
                    context.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u9700\u8981\u7f34\u7eb3\u6807\u4e66\u8d39\u540e\u624d\u80fd\u67e5\u770b\u548c\u4e0b\u8f7d\u6807\u4e66\u3002", (String)"TndPayStatusValidator_6", (String)"scm-tnd-opplugin", (Object[])new Object[0]));
                } else {
                    context.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u672a\u5b8c\u6210\u7f34\u8d39\uff0c\u8bf7\u5148\u7f34\u8d39\u540e\u518d\u64cd\u4f5c\u3002", (String)"TndPayStatusValidator_7", (String)"scm-tnd-opplugin", (Object[])new Object[0]));
                }
            } else {
                context.setMessage(ResManager.loadKDString((String)"\u5df2\u5f03\u6807\u6bb5\u7684\u6807\u6bb5\uff0c\u4e0d\u80fd\u518d\u67e5\u770b\u9644\u4ef6\u3002", (String)"TndPayStatusValidator_9", (String)"scm-tnd-opplugin", (Object[])new Object[0]));
            }
            if ("C020703".equals(feeway)) {
                Set packageIds = rows.stream().map(e -> e.getLong("package.id")).collect(Collectors.toSet());
                context.setPackageIds(packageIds);
            }
        }
    }
}

