/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.SrcNegotiatetypeEnums;
import kd.scm.pds.common.util.SrcExchangeRateUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.pds.common.vie.PdsVieHelper;

public class TndPriceLimitValidator
implements ISrcValidator {
    private static final long serialVersionUID = 8460831337812415389L;

    public void validate(SrcValidatorData srcValidatorData) {
        String negotiateType;
        String tendency = srcValidatorData.getBillObj().getString("project.tendency");
        if (null == tendency || "".equals(tendency) || "3".equals(tendency)) {
            srcValidatorData.setSucced(true);
            return;
        }
        if ("src_negotiatebill".equals(srcValidatorData.getBizObject()) && (null == (negotiateType = srcValidatorData.getBillObj().getString("negotiatetype")) || "".equals(negotiateType) || SrcNegotiatetypeEnums.ONLINE.getValue().equals(negotiateType) || SrcNegotiatetypeEnums.ONLINE_VIE.getValue().equals(negotiateType))) {
            srcValidatorData.setSucced(true);
            return;
        }
        String billId = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)srcValidatorData.getBillObj()));
        String taxtype = srcValidatorData.getBillObj().getString("project.taxtype");
        String decisiontype = srcValidatorData.getBillObj().getString("project.decisiontype");
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)true);
        QFilter qfilters = new QFilter("parentid", "=", (Object)billId);
        qfilters.and("isdiscarded", "=", (Object)"0");
        qfilters.and(new QFilter("price", ">", (Object)BigDecimal.ZERO).or("taxprice", ">", (Object)BigDecimal.ZERO).or("amount", ">", (Object)BigDecimal.ZERO).or("taxamount", ">", (Object)BigDecimal.ZERO));
        qfilters.and(new QFilter("maxprice", ">", (Object)BigDecimal.ZERO).or("maxtaxprice", ">", (Object)BigDecimal.ZERO).or("maxamount", ">", (Object)BigDecimal.ZERO).or("maxtaxamount", ">", (Object)BigDecimal.ZERO));
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilters.toArray(), (String)"purlistseq");
        if (purlistObjs == null || purlistObjs.length == 0) {
            srcValidatorData.setSucced(true);
            return;
        }
        StringBuilder currMsgSb = new StringBuilder();
        HashMap cacheMap = new HashMap(8);
        for (DynamicObject purlistObj : purlistObjs) {
            SrcExchangeRateUtils.getExchangeRate((DynamicObject)purlistObj, (StringBuilder)currMsgSb, cacheMap);
        }
        if (currMsgSb.length() > 0) {
            srcValidatorData.setSucced(false);
            srcValidatorData.setMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u7ef4\u62a4\u6c47\u7387: %1$s", (String)"TndPriceLimitValidator_3", (String)"scm-tnd-opplugin", (Object[])new Object[0]), currMsgSb.toString()));
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (DynamicObject purlistObj : purlistObjs) {
            BigDecimal maxPrice;
            BigDecimal locPrice;
            if ("2".equals(taxtype)) {
                if ("2".equals(decisiontype)) {
                    locPrice = SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"amount", (String)"priceprecision");
                    maxPrice = purlistObj.getBigDecimal("maxamount");
                } else {
                    locPrice = SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"price", (String)"priceprecision");
                    maxPrice = purlistObj.getBigDecimal("maxprice");
                }
            } else if ("2".equals(decisiontype)) {
                locPrice = SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"taxamount", (String)"priceprecision");
                maxPrice = purlistObj.getBigDecimal("maxtaxamount");
            } else {
                locPrice = SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"taxprice", (String)"priceprecision");
                maxPrice = purlistObj.getBigDecimal("maxtaxprice");
            }
            int locpriceprecision = purlistObj.getInt("loccurr.priceprecision");
            builder = PdsVieHelper.verifyLimitPrice((StringBuilder)builder, (String)taxtype, (String)tendency, (DynamicObject)purlistObj, (BigDecimal)locPrice, (BigDecimal)maxPrice, (int)locpriceprecision);
        }
        if (builder.length() > 0) {
            srcValidatorData.setSucced(false);
            if ("1".equals(tendency)) {
                srcValidatorData.setMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u4ef7\u8d8b\u52bf\u4e3a\u53ea\u5141\u8bb8\u964d\u4ef7\uff0c\u62a5\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u6700\u9ad8\u9650\u4ef7\uff1a%1$s", (String)"TndPriceLimitValidator_1", (String)"scm-tnd-opplugin", (Object[])new Object[0]), builder.toString()));
            }
            if ("2".equals(tendency)) {
                srcValidatorData.setMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u4ef7\u8d8b\u52bf\u4e3a\u53ea\u5141\u8bb8\u52a0\u4ef7\uff0c\u62a5\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u6700\u4f4e\u9650\u4ef7\uff1a%1$s", (String)"TndPriceLimitValidator_2", (String)"scm-tnd-opplugin", (Object[])new Object[0]), builder.toString()));
            }
            return;
        }
        srcValidatorData.setSucced(true);
    }
}

