/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class TndRegExpertStatusPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label detaillabel = (Label)this.getView().getControl("detaillabel");
        detaillabel.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long billId = this.getBillId();
        if (billId == 0L) {
            return;
        }
        DynamicObject regExpertObj = this.getRegExpert(billId);
        if (null == regExpertObj) {
            return;
        }
        this.visiableByStatus(regExpertObj);
        this.setStatusSteption(regExpertObj);
    }

    public DynamicObject getRegExpert(Long billId) {
        QFilter filter = new QFilter("id", "=", (Object)billId);
        DynamicObject regExpertObj = QueryServiceHelper.queryOne((String)"tnd_regexpert", (String)"name,number,telephone,email,auditstatus,auditopinion", (QFilter[])filter.toArray());
        if (null == regExpertObj) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u586b\u5199\u6ce8\u518c\u8d44\u6599\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"TndRegExpertStatusPlugin_0", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
        }
        return regExpertObj;
    }

    public void visiableByStatus(DynamicObject regExpertObj) {
        Label titleLable = (Label)this.getView().getControl("name");
        titleLable.setText(regExpertObj.getString("name"));
        Label accountLable = (Label)this.getView().getControl("account");
        accountLable.setText(regExpertObj.getString("telephone"));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"submitlabel", "processlabel", "faillabel", "failtoeditlabel", "successlable"});
        String auditStatus = regExpertObj.getString("auditstatus");
        if ("A".equals(auditStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"submitlabel"});
        } else if ("B".equals(auditStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"processlabel"});
        } else if ("C".equals(auditStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"successlable"});
        } else if ("E".equals(auditStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"faillabel"});
        } else if ("D".equals(auditStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"failtoeditlabel"});
        }
    }

    public void setStatusSteption(DynamicObject regExpertObj) {
        Wizard wizard = (Wizard)this.getControl("wizardap");
        List stepsOptionList = wizard.getStepsOptions();
        stepsOptionList.clear();
        String auditStatus = regExpertObj.getString("auditstatus");
        int currentStep = 0;
        String currentStatus = "process";
        if (!"A".equals(auditStatus)) {
            if ("B".equals(auditStatus)) {
                currentStep = 1;
            } else if ("C".equals(auditStatus)) {
                currentStep = 2;
                currentStatus = "finish";
            } else if ("E".equals(auditStatus) || "D".equals(auditStatus)) {
                currentStep = 2;
                currentStatus = "error";
            }
        }
        this.setSetpOptions(stepsOptionList, regExpertObj);
        wizard.setWizardStepsOptions(stepsOptionList);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
        currentStepMap.put("currentStep", currentStep);
        currentStepMap.put("currentStatus", currentStatus);
        wizard.setWizardCurrentStep(currentStepMap);
    }

    public void setSetpOptions(List<StepsOption> stepsOptionList, DynamicObject regExpertObj) {
        String title = "";
        StringBuilder description = new StringBuilder();
        String auditStatus = regExpertObj.getString("auditstatus");
        for (int i = 0; i < 3; ++i) {
            if (i == 0) {
                title = ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u63d0\u4ea4", (String)"TndRegExpertStatusPlugin_1", (String)"scm-tnd-formplugin", (Object[])new Object[0]);
            } else if (i == 1) {
                title = ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u5ba1\u6279", (String)"TndRegExpertStatusPlugin_2", (String)"scm-tnd-formplugin", (Object[])new Object[0]);
            } else if (i == 2) {
                boolean isShow = false;
                title = ResManager.loadKDString((String)"\u5ba1\u6279\u7ed3\u679c", (String)"TndRegExpertStatusPlugin_3", (String)"scm-tnd-formplugin", (Object[])new Object[0]);
                String auditOpinion = regExpertObj.getString("auditopinion");
                if ("C".equals(auditStatus)) {
                    if (StringUtils.isBlank((String)auditOpinion)) {
                        auditOpinion = ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7", (String)"TndRegExpertStatusPlugin_4", (String)"scm-tnd-formplugin", (Object[])new Object[0]);
                    }
                    isShow = true;
                } else if ("D".equals(auditStatus) || "E".equals(auditStatus)) {
                    isShow = true;
                }
                if (isShow) {
                    description.append(ResManager.loadKDString((String)"\u5ba1\u6279\u610f\u89c1:", (String)"TndRegExpertStatusPlugin_5", (String)"scm-tnd-formplugin", (Object[])new Object[0])).append(auditOpinion);
                }
            }
            StepsOption option = new StepsOption();
            option.setTitle(new LocaleString(title));
            option.setDescription(new LocaleString(description.toString()));
            option.setStatus("finish");
            stepsOptionList.add(option);
        }
    }

    private Long getBillId() {
        Long billId = 0L;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (null == parameter) {
            return billId;
        }
        Object regBillId = parameter.getCustomParam("regBillId");
        if (null == regBillId) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f20\u5165\u7684ID\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6253\u5f00\u65b9\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"TndRegExpertStatusPlugin_6", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
        } else {
            billId = Long.valueOf(String.valueOf(regBillId));
        }
        return billId;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("detaillabel")) {
            String groupId;
            Long billId = this.getBillId();
            if (billId == 0L) {
                return;
            }
            DynamicObject regExpertObj = this.getRegExpert(billId);
            if (null == regExpertObj) {
                return;
            }
            BillOperationStatus billStatus = this.getBillStatus(regExpertObj);
            OperationStatus opStatus = OperationStatus.EDIT;
            if (billStatus.equals((Object)BillOperationStatus.VIEW)) {
                opStatus = OperationStatus.VIEW;
            }
            if ((groupId = MutexHelper.getMutexGroupId((String)"tnd_regexpert", (String)"modify")) != null) {
                BaseShowParameter bsp = new BaseShowParameter();
                bsp.setFormId("tnd_regexpert");
                bsp.setPkId((Object)billId);
                bsp.setBillStatus(billStatus);
                bsp.setStatus(opStatus);
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)bsp);
            }
        }
    }

    public BillOperationStatus getBillStatus(DynamicObject regExpertObj) {
        BillOperationStatus billStatus = BillOperationStatus.VIEW;
        if (null != regExpertObj) {
            String auditStatus = regExpertObj.getString("auditstatus");
            if ("A".equals(auditStatus)) {
                billStatus = BillOperationStatus.EDIT;
            } else if ("D".equals(auditStatus)) {
                billStatus = BillOperationStatus.EDIT;
            }
        }
        return billStatus;
    }
}

