/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.tnd.common.util.TndInviteLetterUtil;

public class TndApplyAndInviteLetterEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        HashSet<Long> supplierIds = new HashSet<Long>(8);
        String entityId = this.getView().getEntityId();
        if (Objects.equals(entityId, "tnd_inviteletter")) {
            DynamicObject inviteObj = this.getModel().getDataEntity();
            if (!Objects.equals(inviteObj.getString("cfmstatus"), "B")) {
                return;
            }
            long supplierId = SrmCommonUtil.getPkValue((DynamicObject)inviteObj.getDynamicObject("supplier"));
            supplierIds.add(supplierId);
        } else if (Objects.equals(entityId, "tnd_apply")) {
            DynamicObject applyObj = this.getModel().getDataEntity();
            if (!Objects.equals(applyObj.getString("enrollstatus"), "E")) {
                return;
            }
            supplierIds.addAll(PdsCommonUtils.getSupplierByUserOfBizPartner());
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_tender", "bar_quote", "bar_viehall", "bar_payment"});
        this.setUnVisible(supplierIds);
        this.setVisibleTenderAndQuote(SrmCommonUtil.getPkValue((DynamicObject)this.getProject()), supplierIds);
    }

    private DynamicObject getProject() {
        String entityId = this.getView().getEntityId();
        if (Objects.equals(entityId, "tnd_inviteletter")) {
            return this.getModel().getDataEntity().getDynamicObject("project");
        }
        return this.getModel().getDataEntity();
    }

    public void setUnVisible(Set<Long> supplierIds) {
        DynamicObject projectObj = this.getProject();
        if (null == projectObj) {
            return;
        }
        String sourceType = projectObj.getString("sourcetype.number");
        if (null != sourceType && (SourceTypeEnums.VIE.getValue().equals(sourceType) || SourceTypeEnums.ELECTRONIC_AUCTION.getValue().equals(sourceType))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_tender", "bar_quote"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_viehall"});
        }
        String feeway = projectObj.getString("feeway.number");
        if (null == feeway || feeway.trim().length() == 0 || "C020701".equals(feeway)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_payment"});
        } else {
            Date stopDate = projectObj.getDate("stopbiddate");
            if (null != stopDate && TimeServiceHelper.now().compareTo(stopDate) > 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_payment"});
                return;
            }
            if (this.isFinishPayment(supplierIds, SrmCommonUtil.getPkValue((DynamicObject)projectObj))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_payment"});
            }
        }
    }

    private boolean isFinishPayment(Set<Long> supplierIds, long projectId) {
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("supplier", "in", supplierIds);
        qfilters.and(new QFilter("paystatus", "=", (Object)PayStatusEnums.NOPAY.getValue()).or("paystatus", "=", (Object)PayStatusEnums.NOCONFIRM.getValue()));
        return !QueryServiceHelper.exists((String)"tnd_payment", (QFilter[])qfilters.toArray());
    }

    public void setVisibleTenderAndQuote(long projectId, Set<Long> supplierIds) {
        QFilter qfilters = new QFilter("project.id", "=", (Object)projectId).and("supplier.id", "in", supplierIds).and("billstatus", "=", (Object)BillStatusEnum.SAVE.getVal()).and(new QFilter("deadline", ">=", (Object)TimeServiceHelper.now()).or("deadline", "is null", (Object)TimeServiceHelper.now()));
        DynamicObject tenderObj = QueryServiceHelper.queryOne((String)"tnd_tenderbill", (String)"id", (QFilter[])qfilters.toArray());
        if (null != tenderObj) {
            this.getPageCache().put("tenderid", tenderObj.getString("id"));
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_tender"});
        } else {
            this.getPageCache().put("tenderid", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_tender"});
        }
        DynamicObject quoteObj = QueryServiceHelper.queryOne((String)"tnd_quotebill", (String)"id", (QFilter[])qfilters.toArray());
        if (null != quoteObj) {
            this.getPageCache().put("quoteid", quoteObj.getString("id"));
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_quote"});
        } else {
            this.getPageCache().put("quoteid", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_quote"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opKey;
        OperationResult result = evt.getOperationResult();
        if (null != result && !result.isSuccess()) {
            return;
        }
        switch (opKey = evt.getOperateKey()) {
            case "tender": {
                this.openTenderBill();
                break;
            }
            case "quote": {
                this.openQuoteBill();
                break;
            }
            case "viehall": {
                this.openVieBill(this.getProject());
                break;
            }
            case "payment": {
                this.openPaymentBill(this.getProject());
                break;
            }
        }
    }

    private void openVieBill(DynamicObject obj) {
        Map paraMap;
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)obj);
        QFilter quoteFilter = new QFilter("project", "=", (Object)projectId);
        String entityId = this.getView().getEntityId();
        if (Objects.equals(entityId, "tnd_apply")) {
            List supplierList = PdsCommonUtils.getSupplierByUserOfBizPartner();
            String supplierType = SupplierUtil.getSupType(null);
            String supFilterPro = SupplierUtil.getSupProBySupType((String)supplierType);
            quoteFilter.and(supFilterPro, "in", (Object)supplierList);
        } else if (Objects.equals(entityId, "tnd_inviteletter")) {
            quoteFilter.and("supplier", "=", (Object)PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getDynamicObject("supplier").getPkValue()));
        }
        quoteFilter.and("iscompete", "=", (Object)"1");
        quoteFilter.and("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal());
        DynamicObject quoteObj = QueryServiceHelper.queryOne((String)"tnd_quotebill", (String)"id", (QFilter[])quoteFilter.toArray());
        if (quoteObj != null && (paraMap = PdsVieHelper.getQuoteBillMap((long)quoteObj.getLong("id"))) != null) {
            String vieturns = paraMap.get("vieturns").toString();
            String targetPageId = PdsCommonUtils.object2String((Object)PdsObjectPools.getInstance((String)PdsCommonUtils.getPageIdKey((IFormView)this.getView(), (String)"tnd_quotebill", (String)(String.valueOf(projectId) + '_' + vieturns))), (String)"");
            OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"tnd_vie_online", (ShowType)ShowType.MainNewTabPage, (Map)paraMap, null, (String)targetPageId);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u7535\u5b50\u7ade\u4ef7\u9879\u76ee\u3002", (String)"TndApplyAndInviteLetterEdit_4", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
    }

    public boolean isOpenTenderType(DynamicObject projectF7Obj) {
        String tenderType = projectF7Obj.getString("tendertype");
        return "2".equals(tenderType);
    }

    public void openPaymentBill(DynamicObject obj) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)obj);
        if (TndInviteLetterUtil.isInviteLetterConfirm((long)projectId) || this.isOpenTenderType(obj)) {
            List supplierList = PdsCommonUtils.getSupplierByUserOfBizPartner();
            String supplierType = SupplierUtil.getSupType(null);
            String supFilterPro = SupplierUtil.getSupProBySupType((String)supplierType);
            QFilter qFilter = new QFilter("project", "=", (Object)projectId);
            qFilter.and(supFilterPro, "in", (Object)supplierList);
            DynamicObjectCollection payObjs = QueryServiceHelper.query((String)"tnd_payment", (String)"id", (QFilter[])qFilter.toArray());
            if (payObjs == null || payObjs.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u65e0\u9700\u7f34\u8d39\u3002", (String)"TndApplyAndInviteLetterEdit_1", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (payObjs.size() == 1) {
                OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"tnd_payment", (Object)((DynamicObject)payObjs.get(0)).getLong("id"), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
            } else {
                Set paySet = payObjs.stream().map(row -> row.getLong("id")).collect(Collectors.toSet());
                QFilter qfilters = new QFilter("id", "in", paySet);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"tnd_payment", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qfilters, null);
            }
        }
    }

    public void openTenderBill() {
        String billId = this.getPageCache().get("tenderid");
        if (null == billId || Long.parseLong(billId.toString()) == 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6295\u6807\u5355", (String)"TndApplyAndInviteLetterEdit_2", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"tnd_tenderbill", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)Long.parseLong(billId.toString()), null, null));
    }

    public void openQuoteBill() {
        String billId = this.getPageCache().get("quoteid");
        if (null == billId || Long.parseLong(billId.toString()) == 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u62a5\u4ef7\u5355", (String)"TndApplyAndInviteLetterEdit_3", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"tnd_quotebill", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)Long.parseLong(billId.toString()), null, null));
    }
}

