/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.enums.EnrollStatusEnums;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.common.util.TndApplyUtils;

public class TndApplyEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject eventobject) {
        super.afterBindData(eventobject);
        this.setEnrollStatus();
        this.setApplyTime();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "reenrollquery": {
                this.reEnrollQuery(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "enroll": 
            case "enrollquery": {
                if (!args.getOperationResult().isSuccess()) break;
                this.openBidEnroll(opKey);
                break;
            }
            case "unenroll": {
                if (!args.getOperationResult().isSuccess()) break;
                this.unEnroll();
                this.getView().invokeOperation("refresh");
                break;
            }
            case "querynotice": {
                this.openQuoNoticeList();
            }
        }
    }

    private void unEnroll() {
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
        QFilter qfilter = new QFilter("billid", "=", (Object)PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue()));
        qfilter.and("supplier", "in", (Object)supplierIds);
        DeleteServiceHelper.delete((String)"src_enrollsupplier", (QFilter[])qfilter.toArray());
        QFilter docFilter = new QFilter("project", "=", (Object)projectId);
        docFilter.and("supplier", "in", (Object)supplierIds);
        if ("tnd_apply".equals(this.getView().getEntityId())) {
            docFilter.and("billtype", "=", (Object)"3");
        } else {
            docFilter.and("billtype", "=", (Object)"4");
        }
        DeleteServiceHelper.delete((String)"src_biddoctplf7", (QFilter[])docFilter.toArray());
    }

    protected void reEnrollQuery(BeforeDoOperationEventArgs evt) {
        long billId = PdsCommonUtils.object2Long((Object)this.getModel().getValue("id"));
        List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        qFilter.and("opkey", "=", (Object)"reenroll");
        if (null == supplierIds || supplierIds.size() <= 0) {
            return;
        }
        qFilter.and("supplier.fbasedataid", "in", (Object)supplierIds);
        OpenFormUtils.openListPage((IFormView)this.getView(), (String)"tnd_bizoperatelog", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, (CloseCallBack)null);
    }

    private void openBidEnroll(String opKey) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(16);
        paraMap.put("project", this.getModel().getDataEntity().getPkValue());
        paraMap.put("stopbiddate", this.getModel().getDataEntity().getDate("stopbiddate"));
        paraMap.put("replydate", this.getModel().getDataEntity().getDate("replydate"));
        paraMap.put("billdate", this.getModel().getDataEntity().getDate("billdate"));
        paraMap.put("opkey", opKey);
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"tnd_bidenroll", (ShowType)ShowType.Modal, paraMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "tnd_bidenroll"));
    }

    private void openQuoNoticeList() {
        QFilter projectFilter = new QFilter("srcbillid", "=", (Object)PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue()));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"sou_notice", (String)"id", (QFilter[])projectFilter.toArray());
        if (rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9879\u76ee\u6682\u65e0\u516c\u544a\u3002", (String)"TndApplyEdit_1", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
            return;
        }
        Set noticeIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter noticeFilter = new QFilter("id", "in", noticeIds);
        OpenFormUtils.openListPage((IFormView)this.getView(), (String)"quo_notice", (ShowType)ShowType.MainNewTabPage, null, (QFilter)noticeFilter, null);
    }

    public void setEnrollStatus() {
        List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        projectIds.add((Long)this.getModel().getDataEntity().getPkValue());
        Set enrollIds = TndApplyUtils.getEnrollIds((List)supplierIds, projectIds);
        Set inviteIds = TndApplyUtils.getInviteIds((List)supplierIds, projectIds);
        String enrollStatus = TndApplyUtils.getEnrollStatus((DynamicObject)this.getModel().getDataEntity(), (Set)enrollIds, (Set)inviteIds, (Date)this.getModel().getDataEntity().getDate("replydate"), (Date)this.getModel().getDataEntity().getDate("stopbiddate"));
        this.getModel().setValue("enrollstatus", (Object)enrollStatus);
        if (EnrollStatusEnums.UNENROLL.getValue().equals(enrollStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_enroll"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_enroll"});
        }
        Set enrollQuerySet = PdsCommonUtils.buildSet((String[])new String[]{EnrollStatusEnums.ENROLLED.getValue(), EnrollStatusEnums.INVITED.getValue(), EnrollStatusEnums.UNINVITED.getValue()});
        if (enrollQuerySet.contains(enrollStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"enrollquery"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"enrollquery"});
        }
        Set unEnrollSet = PdsCommonUtils.buildSet((String[])new String[]{EnrollStatusEnums.ENROLLED.getValue()});
        if (unEnrollSet.contains(enrollStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"unenroll"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"unenroll"});
        }
    }

    private void setApplyTime() {
        QFilter qfilter = new QFilter("billid", "=", this.getModel().getDataEntity().getPkValue());
        List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
        qfilter.and("supplier.id", "in", (Object)supplierIds);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_enrollsupplier", (String)"applytime", (QFilter[])qfilter.toArray());
        Date applyTime = cols.stream().map(col -> col.getDate("applytime")).filter(Objects::nonNull).max(Date::compareTo).orElse(null);
        if (Objects.nonNull(applyTime)) {
            this.getModel().setValue("applytime", (Object)applyTime);
            this.getView().setVisible(Boolean.TRUE, new String[]{"applytime"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"applytime"});
        }
    }
}

