/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.question.PdsQuestionFacade;
import kd.scm.pds.common.util.MultiTypeEditUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.formplugin.comp.TndAptitudeCopyHistory;

public class TndAptitudeBillEdit
extends AbstractBillPlugIn {
    private volatile boolean isExiting = false;

    public void beforeBindData(EventObject arg0) {
        super.beforeBindData(arg0);
        if (PdsCommonUtils.isTnd((String)this.getView().getFormShowParameter().getAppId(), (String)RequestContext.get().getUserType())) {
            this.getModel().setValue("issupplier", (Object)true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"answerque"});
        }
        this.createNewEntryRow();
        this.getModel().setDataChanged(false);
    }

    private void createNewEntryRow() {
        long billId = SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity());
        if (billId == 0L) {
            return;
        }
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"src_aptitudetask");
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        boolean isSupplier = this.getModel().getDataEntity().getBoolean("issupplier");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        model.beginInit();
        for (DynamicObject row : rows) {
            String itemType = PdsCommonUtils.object2String((Object)row.get("index.itemtype"), (String)"1");
            if (isSupplier && !"1".equals(itemType) && !"2".equals(itemType) && !"3".equals(itemType)) continue;
            PdsCommonUtils.setTableValueSetterValue((TableValueSetter)ts, (DynamicObject)row, (List)properties, (int)index);
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
        model.endInit();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        if (evt.isCancel()) {
            return;
        }
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "answer": {
                PdsQuestionFacade.openQuestionList((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tnd_question", (boolean)false);
                break;
            }
            case "save": 
            case "submit": 
            case "audit": {
                this.saveEntryData();
                break;
            }
        }
    }

    public void saveEntryData() {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("entryentity");
        if (entryRows.size() == 0) {
            return;
        }
        Map<Long, DynamicObject> entryMap = entryRows.stream().collect(Collectors.groupingBy(e -> e.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        long billId = SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity());
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"src_aptitudetask");
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        HashSet<String> excludedFields = new HashSet<String>(2);
        excludedFields.add("index");
        excludedFields.add("indexdimension");
        excludedFields.add("indexscore");
        excludedFields.add("indexweight");
        excludedFields.add("indexrule");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        boolean isSupplier = this.getModel().getDataEntity().getBoolean("issupplier");
        for (DynamicObject row : rows) {
            DynamicObject entryObj;
            String itemType = PdsCommonUtils.object2String((Object)row.get("index.itemtype"), (String)"1");
            if (!BillStatusEnum.SAVE.getVal().equals(row.getString("entrystatus")) || isSupplier && !"1".equals(itemType) && !"2".equals(itemType) || !isSupplier && !"1".equals(itemType) && !"3".equals(itemType) && !"4".equals(itemType) || null == (entryObj = entryMap.get(row.getLong("id")))) continue;
            PdsCommonUtils.copyDynamicObjectValue((DynamicObject)entryObj, (DynamicObject)row, (List)properties, excludedFields, (int)-1);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject)billObj);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opKey;
        super.afterDoOperation(evt);
        switch (opKey = evt.getOperateKey()) {
            case "copyhistory": {
                ExtPluginContext context = new ExtPluginContext();
                context.setView(this.getView());
                context.setProjectObj(this.getModel().getDataEntity().getDynamicObject("project"));
                ExtPluginFactory.executeExtplugin((String)TndAptitudeCopyHistory.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
                break;
            }
            case "audit": {
                if (!BillStatusEnum.AUDIT.getVal().equals(this.getModel().getValue("cfmstatus"))) break;
                OperationResult operationResult = evt.getOperationResult();
                if (operationResult.isSuccess()) {
                    operationResult.setShowMessage(false);
                }
                StringBuilder sb = new StringBuilder();
                sb.append(this.getModel().getDataEntity().getString("supplier.name"));
                sb.append('\n');
                sb.append(this.getModel().getDataEntity().getString("project.bidname"));
                sb.append('\n');
                sb.append(ResManager.loadKDString((String)"\u8d44\u8d28\u5ba1\u67e5\u56de\u590d\u6210\u529f\u3002", (String)"TndAptitudeBillEdit_0", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                this.getView().showSuccessNotification(sb.toString());
                break;
            }
            case "batchfillattach": {
                AttachmentUtils.batchFillAttach((IFormView)this.getView(), (String)"entryentity", (String)"aptitudereply_fj");
                break;
            }
        }
        if (("audit".equals(opKey) || "unaudit".equals(opKey)) && evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        if (!this.isExiting && !evt.isCancel()) {
            String callBackId;
            String cfmStatus;
            boolean isSupplier = this.getModel().getDataEntity().getBoolean("issupplier");
            String string = cfmStatus = isSupplier ? this.getModel().getDataEntity().getString("cfmstatus_sup") : this.getModel().getDataEntity().getString("cfmstatus_pur");
            if (BillStatusEnum.SAVE.getVal().equals(cfmStatus) && !"1".equals(callBackId = this.getPageCache().get("pdsCompDataChangeCallBackKey"))) {
                evt.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u5904\u7406\u7684\u9879\u76ee\u672a\u5b8c\u6210\u8d44\u8d28\u5ba1\u67e5\u56de\u590d\uff0c\u8bf7\u8fdb\u884c\u56de\u590d\u6216\u4fdd\u5b58\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"TndAptitudeBillEdit_1", (String)"scm-tnd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("exit"));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"exit", (CharSequence)evt.getCallBackId()) && evt.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.isExiting = true;
            this.getView().invokeOperation("close");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"aptitudereply"});
    }

    public void click(EventObject evt) {
        String fieldName = ((Control)evt.getSource()).getKey();
        if (!"aptitudereply".equals(fieldName)) {
            return;
        }
        Map paramMap = MultiTypeEditUtils.getParamMap((String)((Object)((Object)this)).getClass().getName(), (String)"index", (String)"valuebizobject", (String)"valuetype", (String)"index");
        MultiTypeEditUtils.clickHandle((IFormView)this.getView(), (EventObject)evt, (Map)paramMap);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        MultiTypeEditUtils.closedCallBackHandle((IFormView)this.getView(), (ClosedCallBackEvent)evt, null);
    }
}

