/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class TndBidDocUploadEdit
extends AbstractBillPlugIn {
    public static final String PARENTID = "parentid";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        String entityId = parentView.getEntityId();
        if (entityId.equals("tnd_tenderbill")) {
            DynamicObject obj = parentView.getModel().getDataEntity();
            long billId = PdsCommonUtils.object2Long((Object)obj.getPkValue());
            long projectId = obj.getLong("project.id");
            boolean isSplitBidDoc = obj.getBoolean("issplitdoc");
            long supplierId = obj.getLong("supplier.id");
            if (supplierId > 0L) {
                this.copyDataFromBidDoc(billId, projectId, supplierId, isSplitBidDoc);
            }
        }
    }

    private void copyDataFromBidDoc(long billId, long projectId, long supplierId, boolean isSplitBidDoc) {
        DynamicObject tempObj;
        String compKey = this.getView().getEntityId();
        if (!isSplitBidDoc && !compKey.equals("src_biddoc_src")) {
            compKey = "src_biddoc_src";
        }
        QFilter qFilter = new QFilter(PARENTID, "=", (Object)String.valueOf(billId)).or("id", "=", (Object)billId);
        String entityId = this.getView().getEntityId();
        HashSet<Long> packageIdSet = null;
        if (StringUtils.equals((CharSequence)"src_biddoc_tnd", (CharSequence)entityId)) {
            packageIdSet = this.getSupplierPackageIdSet(projectId, supplierId);
        }
        if ((tempObj = BusinessDataServiceHelper.loadSingle((String)compKey, (String)"id", (QFilter[])new QFilter[]{qFilter})) == null) {
            return;
        }
        DynamicObject compObj = BusinessDataServiceHelper.loadSingle((Object)tempObj.getPkValue(), (String)compKey);
        if (compObj == null) {
            return;
        }
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.deleteEntryData("entryentity");
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        DynamicObject projectInfo = BusinessDataServiceHelper.loadSingle((String)"src_project", (String)"id,managetype", (QFilter[])new QFilter[]{qFilter});
        String managetype = "1";
        if (projectInfo != null) {
            managetype = projectInfo.getString("managetype");
        }
        String supType = SupplierUtil.getSupType(null);
        int i = 0;
        for (DynamicObject row : rows) {
            long packageId;
            if (StringUtils.equals((CharSequence)"2", (CharSequence)managetype) && ((packageId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package"))) == 0L || packageIdSet != null && packageIdSet.size() > 0 && !packageIdSet.contains(packageId))) continue;
            for (String pro : properties) {
                if (pro.equals("package") || pro.equals("packfiletype") || pro.equals("isneedbiddoc") || pro.equals("entrystatus")) {
                    if (row.get(pro) instanceof DynamicObject) {
                        ts.set(pro, row.getDynamicObject(pro).getPkValue(), i);
                    } else {
                        ts.set(pro, row.get(pro), i);
                    }
                }
                ts.set("project", (Object)projectId, i);
                ts.set("suppliertype", (Object)supType, i);
                ts.set("supplier", (Object)supplierId, i);
                ts.set("billtype", (Object)"2", i);
            }
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private HashSet<Long> getSupplierPackageIdSet(long projectId, long supplierId) {
        QFilter qFilter = new QFilter(PARENTID, "=", (Object)String.valueOf(projectId)).or("id", "=", (Object)projectId);
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((String)"src_supplier_invite", (String)"entrysupplier,entrysupplier.package,entrysupplier.suppliertype,entrysupplier.supplier,entrysupplier.isinvite", (QFilter[])new QFilter[]{qFilter});
        if (tempObj == null) {
            return null;
        }
        DynamicObjectCollection biddocSrcRows = tempObj.getDynamicObjectCollection("entrysupplier");
        if (biddocSrcRows == null || biddocSrcRows.size() == 0) {
            return null;
        }
        HashSet<Long> packageIdSet = new HashSet<Long>();
        for (DynamicObject biddocSrcRow : biddocSrcRows) {
            DynamicObject packageInfo;
            String supType = biddocSrcRow.getString("suppliertype");
            DynamicObject bdSup = SupplierUtil.getBdSupplier((DynamicObject)biddocSrcRow.getDynamicObject("supplier"), (String)supType);
            long biddocSupplier = SrmCommonUtil.getPkValue((DynamicObject)bdSup);
            if (supplierId != biddocSupplier || !biddocSrcRow.getBoolean("isinvite") || (packageInfo = biddocSrcRow.getDynamicObject("package")) == null) continue;
            packageIdSet.add(SrmCommonUtil.getPkValue((DynamicObject)biddocSrcRow.getDynamicObject("package")));
        }
        return packageIdSet;
    }
}

