/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Html;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.common.enums.TndLettersTypeEnum;

public class TndDocTplEdit
extends AbstractBillPlugIn {
    private static final String NOT_SHOW_MESSAGE = "notShowMessage";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object billidF7 = this.getModel().getValue("project");
        if (billidF7 == null) {
            return;
        }
        Object billid = ((DynamicObject)billidF7).get("id");
        String type = this.getModel().getDataEntity(true).getString("supletterstype");
        String queryEntityId = "pds_noticesupplier";
        QFilter filter = new QFilter("supplierentry.entryproject", "=", billid);
        filter = filter.and("supplierentry.supletterstype", "=", (Object)type);
        if (queryEntityId == null) {
            return;
        }
        DynamicObject docpreviewtpl = BusinessDataServiceHelper.loadSingle((String)queryEntityId, (String)"lettersentry,lettersentry.letterssuppliertype,lettersentry.letterssupplier,lettersentry.portalcontent,lettersentry.letterstype", (QFilter[])new QFilter[]{filter});
        Object supplierObj = this.getModel().getValue("supplier");
        if (supplierObj == null || docpreviewtpl == null) {
            return;
        }
        Object supplierId = ((DynamicObject)supplierObj).get("id");
        DynamicObjectCollection contentColls = docpreviewtpl.getDynamicObjectCollection("lettersentry");
        for (DynamicObject entry : contentColls) {
            String letterstype;
            DynamicObject lettersupplier = entry.getDynamicObject("letterssupplier");
            if (lettersupplier == null) {
                return;
            }
            Object letterSupplierId = lettersupplier.get("id");
            if (!letterSupplierId.equals(supplierId) || !StringUtils.equals((CharSequence)type, (CharSequence)(letterstype = entry.getString("letterstype")))) continue;
            Html html = (Html)this.getControl("htmlap");
            html.setConent(entry.getString("portalcontent").replace("{", "").replace("}", ""));
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        DynamicObject obj;
        String letterType;
        super.preOpenForm(e);
        BillShowParameter showParameter = (BillShowParameter)e.getFormShowParameter();
        Object pkId = showParameter.getPkId();
        String entityName = showParameter.getFormId();
        if (null == pkId || null == entityName) {
            return;
        }
        if (QueryServiceHelper.exists((String)entityName.toString(), (Object)pkId) && !Objects.equals(letterType = TndLettersTypeEnum.fromVal((String)(obj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityName.toString())).getString("supletterstype")), TndLettersTypeEnum.UNKNOW.getName())) {
            showParameter.setCaption(letterType);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": 
            case "refuse": {
                this.getPageCache().put(NOT_SHOW_MESSAGE, "1");
                this.getView().invokeOperation("save");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        IPageCache cache;
        String key = evt.getOperateKey();
        if ("confirm".equals(key) && evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
        }
        if (Objects.equals(key, "save") && StringUtils.isNotBlank((CharSequence)(cache = this.getPageCache()).get(NOT_SHOW_MESSAGE))) {
            evt.getOperationResult().setShowMessage(false);
            cache.remove(NOT_SHOW_MESSAGE);
        }
    }
}

