/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class TndPayMentPlugin
extends AbstractBillPlugIn {
    private volatile boolean isExiting = false;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        Object paystatus = model.getValue("paystatus");
        if (PayStatusEnums.NOPAY.getValue().equals(paystatus.toString())) {
            if (BigDecimal.ZERO.compareTo((BigDecimal)model.getValue("payamount")) == 0) {
                model.setValue("payamount", model.getValue("amount"));
            }
            model.setValue("paydate", (Object)TimeServiceHelper.now());
            this.getModel().setDataChanged(false);
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"payamount", "paydate", "remark"});
            DecimalEdit payamount = (DecimalEdit)this.getView().getControl("payamount");
            DateTimeEdit paydate = (DateTimeEdit)this.getView().getControl("paydate");
            payamount.setMustInput(false);
            paydate.setMustInput(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key = evt.getOperateKey();
        if (("submit".equals(key) || "unsubmit".equals(key)) && evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        String callBackId;
        super.beforeClosed(evt);
        if (!this.isExiting && !evt.isCancel() && BillStatusEnum.SAVE.getVal().equals(this.getModel().getDataEntity().getString("entrystatus")) && !"1".equals(callBackId = this.getPageCache().get("pdsCompDataChangeCallBackKey"))) {
            evt.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u5904\u7406\u7684\u7f34\u8d39\u5355\u672a\u5b8c\u6210\u7f34\u8d39\uff0c\u8bf7\u8fdb\u884c\u63d0\u4ea4(\u5b8c\u6210\u7f34\u8d39)\u6216\u4fdd\u5b58(\u6682\u5b58\u6570\u636e)\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"TndPayMentPlugin_0", (String)"scm-tnd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("exit"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"exit", (CharSequence)evt.getCallBackId()) && evt.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.isExiting = true;
            this.getView().invokeOperation("close");
        }
    }
}

