/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.FeatureCheckUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandlerFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.formplugin.edit.PdsBillCompTplEdit;
import kd.scm.tnd.common.util.TndListFilterUtil;

public class TndProjectEdit
extends PdsBillCompTplEdit {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Map checkResult = FeatureCheckUtil.checkTndFeature();
        if (!((Boolean)checkResult.get("hasLicense")).booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(String.valueOf(checkResult.get("licenseMsg")));
        } else {
            QFilter inviteFilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"tnd_project", (IFormView)this.getView(), null);
            QFilter openFilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"tnd_apply", (IFormView)this.getView(), null);
            QFilter qfilter = inviteFilter.or(openFilter);
            Long pkId = 0L;
            BillShowParameter showParam = (BillShowParameter)e.getSource();
            Object pkIdStr = showParam.getPkId();
            if (pkIdStr instanceof String) {
                pkId = Long.parseLong(String.valueOf(pkIdStr));
            } else if (pkIdStr instanceof Long) {
                pkId = (Long)pkIdStr;
            }
            qfilter.and("id", "=", (Object)pkId);
            boolean exists = QueryServiceHelper.exists((String)showParam.getFormId(), (QFilter[])qfilter.toArray());
            if (!exists) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbf\u95ee\u6743\u9650", (String)"TndProjectEdit_0", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Map checkResult = FeatureCheckUtil.checkTndFeature();
        if (!((Boolean)checkResult.get("hasLicense")).booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(String.valueOf(checkResult.get("licenseMsg")));
            return;
        }
    }

    public void beforeBindData(EventObject e) {
        this.setSourceType();
        this.setBizStatus();
        this.setTemplate();
    }

    private void setSourceType() {
        IDataModel model = this.getModel();
        if (model.getDataEntity().getDynamicObject("srctype") == null) {
            QFilter srctypeFilter;
            DynamicObject tempObj;
            QFilter projectFilter = new QFilter("id", "=", (Object)Long.parseLong(this.getModel().getDataEntity().getPkValue().toString()));
            DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project", (String)"sourcetype,tendertype", (QFilter[])new QFilter[]{projectFilter});
            if (projectObj == null) {
                return;
            }
            String tendertype = projectObj.getString("tendertype");
            if (tendertype == null || tendertype.trim().equals("")) {
                tendertype = "1";
            }
            if ((tempObj = QueryServiceHelper.queryOne((String)"pds_flowconfig", (String)"id", (QFilter[])new QFilter[]{srctypeFilter = new QFilter("issupplier", "=", (Object)Character.valueOf('1')).and("tendertype", "=", (Object)tendertype)})) != null) {
                model.setValue("srctype", (Object)tempObj.getLong("id"));
            }
        }
    }

    private void setTemplate() {
        IDataModel model = this.getModel();
        if (model.getDataEntity().getDynamicObject("template") == null) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("biznodebizobject", this.getView().getEntityId());
            paramMap.put("sourcetype", this.getModel().getDataEntity().getLong("sourcetype.id"));
            long templateId = SchemeFilterUtils.getFirstSchemeId((DynamicObject)model.getDataEntity(), (String)"pds_tplconfig_filter", paramMap);
            if (templateId > 0L) {
                model.setValue("template", (Object)templateId);
                DynamicObject obj = model.getDataEntity(true);
                DynamicObject purListObj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"src_purlist");
                TemplateUtil.createTplEntryData((DynamicObject)purListObj, (DynamicObject)obj, (boolean)true);
            }
        }
    }

    public void afterBindData(EventObject eventobject) {
        super.afterBindData(eventobject);
        this.getModel().setDataChanged(false);
    }

    private void setBizStatus() {
        DynamicObjectCollection bizNodes = this.getModel().getEntryEntity("entrymainflow");
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isNeedInvite = billObj.getBoolean("srctypeid.isneedinvite");
        if (!isNeedInvite && !(isNeedInvite = "2".equals(billObj.getString("isneedinvite")))) {
            for (int i = 0; i < bizNodes.size(); ++i) {
                if (!Objects.equals(((DynamicObject)bizNodes.get(i)).getString("biznode.number"), "34")) continue;
                bizNodes.remove(i);
            }
        }
        List supplierList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        SrcNodeStatusContext context = new SrcNodeStatusContext();
        context.setProjectId(projectId);
        context.setSupplierList(supplierList);
        context.setNodeList(new ArrayList());
        Object supplierType = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"suppliertype");
        if (supplierType == null || "".equals(supplierType) || "bd_supplier".equals(supplierType.toString())) {
            context.setSupplierType("bd_supplier");
        } else {
            context.setSupplierType("src_supplier");
        }
        TndListFilterUtil.isConfirm((DynamicObject)this.getModel().getDataEntity(), (SrcNodeStatusContext)context);
        int index = 0;
        for (DynamicObject bizNode : bizNodes) {
            context.setNodeObj(bizNode);
            context.setNodeSeq(index);
            SrcNodeStatusHandler nodeHandler = SrcNodeStatusHandlerFactory.getStrategyInstance((SrcNodeStatusContext)context);
            if (nodeHandler != null) {
                nodeHandler.nodeStatusHandle(context);
                this.getModel().setValue("flowbizstatus", (Object)context.getBizStatus(), index);
            }
            ++index;
        }
        this.setActivateNode(supplierList, projectId, index);
        HashMap<String, String> nodeDataMap = new HashMap<String, String>();
        String nodeListStr = SerializationUtils.toJsonString((Object)context.getNodeList());
        nodeDataMap.put("data", nodeListStr);
        BizLog.log((String)("setBizStatus nodeListStr:" + nodeListStr));
        this.getPageCache().put(nodeDataMap);
    }

    private void setActivateNode(List<Long> supplierList, long projectId, int index) {
        boolean isEnd;
        int lastIndex = 0;
        int currIndex = -1;
        for (int i = index - 1; i >= 0; --i) {
            String status = (String)this.getModel().getValue("flowbizstatus", i);
            if (status.equals(ProcessStatusEnums.PROCESSED.getValue()) || status.equals(ProcessStatusEnums.CLOSED.getValue())) {
                lastIndex = i + 1;
                break;
            }
            if (currIndex >= 0 || !status.equals(ProcessStatusEnums.PROCESSING.getValue())) continue;
            currIndex = i;
        }
        if (isEnd = this.isEnd(supplierList, projectId)) {
            for (int i = 0; i < index; ++i) {
                if (this.getModel().getValue("flowbizstatus", i).equals(ProcessStatusEnums.PROCESSED.getValue())) continue;
                this.getModel().setValue("flowbizstatus", (Object)ProcessStatusEnums.CLOSED.getValue(), i);
            }
        } else if (lastIndex >= 0 && lastIndex < index && lastIndex > currIndex) {
            this.getModel().setValue("flowbizstatus", (Object)ProcessStatusEnums.PROCESSING.getValue(), lastIndex);
        }
    }

    private boolean isEnd(List<Long> supplierList, long projectId) {
        boolean isEnd = false;
        Date stopBidDate = this.getModel().getDataEntity().getDate("stopbiddate");
        Date currDate = new Date();
        QFilter commonQfitler = new QFilter("project", "=", (Object)projectId);
        commonQfitler.and("supplier.supplier", "in", supplierList);
        QFilter inviteFilter = commonQfitler.copy();
        inviteFilter.and("cfmstatus", "=", (Object)"C");
        boolean isReject = QueryServiceHelper.exists((String)"tnd_inviteletter", (QFilter[])new QFilter[]{inviteFilter});
        if (isReject) {
            isEnd = true;
        }
        if (!isReject && null != stopBidDate && currDate.after(stopBidDate)) {
            commonQfitler.and("billstatus", "=", (Object)"C");
            boolean isTender = QueryServiceHelper.exists((String)"tnd_tenderbill", (QFilter[])new QFilter[]{commonQfitler});
            if (!isTender && !(isTender = QueryServiceHelper.exists((String)"tnd_quotebill", (QFilter[])new QFilter[]{commonQfitler}))) {
                isEnd = true;
            }
        }
        return isEnd;
    }
}

