/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.util.IDCardCommonUtil;
import kd.bos.servicehelper.QueryServiceHelper;

public class TndRegExpertEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String USERNAME_REGEX = "^(?!_)(?!.*?_$)[a-zA-Z0-9_\\u4e00-\\u9fa5]+$";
    private String orgActionId = "auditOrgActionId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control orgfieldEdit = this.getView().getControl("auditorg");
        if (Objects.nonNull(orgfieldEdit) && orgfieldEdit instanceof BasedataEdit) {
            BasedataEdit basedataEdit = (BasedataEdit)orgfieldEdit;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        QFilter filter;
        DynamicObject auditOrg;
        super.afterBindData(e);
        DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
        if (null != orgObj && null != (auditOrg = QueryServiceHelper.queryOne((String)"tnd_auditorg", (String)"id", (QFilter[])(filter = new QFilter("org.id", "=", orgObj.getPkValue())).toArray()))) {
            this.getModel().beginInit();
            this.getModel().setValue("auditorg", (Object)auditOrg.getLong("id"));
            this.getModel().endInit();
            this.getView().updateView("auditorg");
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opKey;
        super.beforeDoOperation(evt);
        switch (opKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "submit": {
                Pattern pattern;
                Matcher matcher;
                Object username;
                Object idNumber = this.getModel().getValue("idnumber");
                if (StringUtils.isNotBlank((Object)idNumber)) {
                    String idCard = idNumber.toString().replace(" ", "");
                    this.getModel().setValue("idnumber", (Object)idCard);
                    IDCardCommonUtil idCardUtil = new IDCardCommonUtil(idCard);
                    String errorMsg = idCardUtil.getErrorMsg();
                    if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                        evt.setCancel(true);
                        evt.setCancelMessage(errorMsg);
                        this.getView().showErrorNotification(errorMsg);
                        return;
                    }
                    if (this.validIdNumber(idCard)) {
                        errorMsg = ResManager.loadKDString((String)"\u8be5\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u6392\u67e5\u3002", (String)"TndRegExpertEdit_5", (String)"scm-tnd-formplugin", (Object[])new Object[0]);
                        evt.setCancel(true);
                        evt.setCancelMessage(errorMsg);
                        this.getView().showErrorNotification(errorMsg);
                        return;
                    }
                }
                if (!StringUtils.isNotBlank((Object)(username = this.getModel().getValue("name"))) || (matcher = (pattern = Pattern.compile(USERNAME_REGEX)).matcher(String.valueOf(username))).matches()) break;
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7528\u6237\u540d\u201d\u53ea\u80fd\u5305\u542b\u4e2d\u6587\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u5e76\u4e14\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u548c\u7ed3\u5c3e\u3002", (String)"TndRegExpertEdit_0", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public boolean validIdNumber(String idNumber) {
        QFilter qFilter = new QFilter("idnumber", "=", (Object)idNumber);
        qFilter.and("id", "!=", this.getModel().getDataEntity().getPkValue());
        boolean isExists = QueryServiceHelper.exists((String)"src_regexpert", (QFilter[])qFilter.toArray());
        if (isExists) {
            return true;
        }
        qFilter = new QFilter("idcard", "=", (Object)idNumber);
        isExists = QueryServiceHelper.exists((String)"bos_user", (QFilter[])qFilter.toArray());
        return isExists;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperEvt) {
        String opKey;
        super.afterDoOperation(afterDoOperEvt);
        switch (opKey = afterDoOperEvt.getOperateKey()) {
            case "submit": 
            case "close": {
                if (!afterDoOperEvt.getOperationResult().isSuccess()) break;
                Object regBillId = this.getModel().getDataEntity().getPkValue();
                FormShowParameter bsp = new FormShowParameter();
                bsp.setFormId("tnd_regfinish");
                HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
                if (StringUtils.equals((CharSequence)"close", (CharSequence)opKey)) {
                    paramMap.put("close", true);
                }
                paramMap.put("isfinish", true);
                paramMap.put("regBillId", String.valueOf(regBillId));
                bsp.setCustomParams(paramMap);
                bsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().returnDataToParent((Object)bsp);
                this.getView().close();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldKey;
        super.propertyChanged(evt);
        switch (fieldKey = evt.getProperty().getName()) {
            case "idnumber": {
                this.idCardChanged(evt);
                break;
            }
            case "auditorg": {
                DynamicObject auditOrgObj = (DynamicObject)evt.getChangeSet()[0].getNewValue();
                DynamicObject orgObj = null;
                if (null != auditOrgObj) {
                    orgObj = auditOrgObj.getDynamicObject("org");
                }
                this.getModel().setValue("org", (Object)orgObj);
                this.getModel().setValue("createorg", (Object)orgObj);
                this.getModel().setValue("useorg", (Object)orgObj);
                break;
            }
        }
    }

    private void idCardChanged(PropertyChangedArgs e) {
        Object idNumber = this.getModel().getValue("idnumber");
        if (StringUtils.isNotBlank((Object)idNumber)) {
            String idCard = idNumber.toString().replace(" ", "");
            this.getModel().setValue("idnumber", (Object)idCard);
            IDCardCommonUtil idCardUtil = new IDCardCommonUtil(idCard);
            String errorMsg = idCardUtil.getErrorMsg();
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                String birthday;
                String seqNum = idCardUtil.getSeqNum();
                if (StringUtils.isNotBlank((CharSequence)seqNum)) {
                    try {
                        this.getModel().setValue("sex", (Object)(idCardUtil.isMan() ? "1" : "2"));
                    }
                    catch (Exception arg8) {
                        BizLog.log((String)ResManager.loadKDString((String)"\u6027\u522b\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (String)"TndRegExpertEdit_3", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(birthday = idCardUtil.getBirthday()))) {
                    try {
                        this.getModel().setValue("birthdate", (Object)idCardUtil.getBirthday());
                    }
                    catch (Exception arg7) {
                        BizLog.log((String)ResManager.loadKDString((String)"\u201c\u65e5\u671f\u683c\u5f0f\u201d\u8f6c\u6362\u5f02\u5e38\u3002", (String)"TndRegExpertEdit_4", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                    }
                }
            } else {
                this.getView().showErrorNotification(errorMsg);
            }
        } else {
            this.getModel().setValue("sex", (Object)"");
            this.getModel().setValue("birthdate", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            default: 
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ArrayList returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (this.orgActionId.equals(actionId) && !CollectionUtils.isEmpty((Collection)(returnData = (ArrayList)closedCallBackEvent.getReturnData()))) {
            this.getModel().setValue("org", returnData.get(0));
        }
    }
}

