/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.enroll.IPdsEnrollHandler;
import kd.scm.pds.common.enroll.PdsEnrollContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.formplugin.edit.PdsDetailBidDocUploadHandler;

public class TndVieAttachmentEdit
extends AbstractFormPlugin
implements UploadListener {
    public void afterCreateNewData(EventObject e) {
        this.setAttachmentEnable();
        this.setEntryAttachment();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBillAttachment();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEvt) {
        super.afterDoOperation(afterDoOperationEvt);
        if (afterDoOperationEvt.getOperateKey().equals("confirm") && afterDoOperationEvt.getOperationResult().isSuccess()) {
            try {
                this.commitBillAttachment();
                this.commitEntryAttachment();
                this.commitClassAttachment();
                this.getView().showMessage(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u6210\u529f\u3002", (String)"TndVieAttachmentEdit_0", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5\u3002", (String)"TndVieAttachmentEdit_1", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        ArrayList<String> fileNames = new ArrayList<String>(8);
        for (Object url : evt.getUrls()) {
            fileNames.add((String)((Map)url).get("name"));
        }
        QFilter qfilters = new QFilter("finterid", "=", (Object)String.valueOf(this.getBillId()));
        qfilters.and("fattachmentpanel", "=", (Object)"attachmentpanel");
        qfilters.and("fbilltype", "=", (Object)"tnd_quotebill");
        qfilters.and("fattachmentname", "in", fileNames);
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])qfilters.toArray());
    }

    protected void commitBillAttachment() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List attachments = attachmentPanel.getAttachmentData();
        if (null == attachments || attachments.size() == 0) {
            return;
        }
        AttachmentUtils.convertTempAttachments((List)attachments);
        AttachmentServiceHelper.upload((String)"tnd_quotebill", (Object)this.getBillId(), (String)"attachmentpanel", (List)attachments);
    }

    protected void commitEntryAttachment() {
        DynamicObject[] purlistObjs;
        DynamicObjectCollection rows = this.getView().getModel().getEntryEntity("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        Map<Long, DynamicObject> entryMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("srcentryid"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        Set idSet = rows.stream().map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
        QFilter qfilters = new QFilter("id", "in", idSet);
        for (DynamicObject purlistObj : purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"purlistentry_supfj", (QFilter[])qfilters.toArray())) {
            DynamicObject attachObj = entryMap.get(purlistObj.getLong("id"));
            purlistObj.set("purlistentry_supfj", attachObj.get("purlistentry_supfj"));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])purlistObjs);
    }

    protected void commitClassAttachment() {
        PdsEnrollContext context = new PdsEnrollContext();
        context.setBillObj(this.getModel().getDataEntity(true));
        IPdsEnrollHandler handler = (IPdsEnrollHandler)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(PdsDetailBidDocUploadHandler.class.getName());
        handler.process(context);
    }

    private void setEntryAttachment() {
        HashSet excFields = new HashSet();
        QFilter qfilter = this.getPurlistFilter();
        PdsCommonUtils.createEntryEntity((IFormView)this.getView(), (String)"src_purlistf7", (QFilter)qfilter, excFields, (String)"entryentity");
    }

    private void setBillAttachment() {
        QFilter qfilter = new QFilter("id", "=", (Object)this.getBillId());
        AttachmentUtils.setQuoteBillAttachment((IFormView)this.getView(), (QFilter)qfilter, (String)"attachmentpanel", (String)"attachmentpanel");
    }

    public void setAttachmentEnable() {
        if (this.isQuoteBillAudit()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmentpanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_confirm"});
            this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"purlistentry_supfj"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity2"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"newentry", "deleteentry"});
        }
    }

    private boolean isQuoteBillAudit() {
        QFilter qfilters = new QFilter("id", "=", (Object)this.getBillId());
        qfilters.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        return QueryServiceHelper.exists((String)"tnd_quotebill", (QFilter[])qfilters.toArray());
    }

    private long getBillId() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long billId = PdsCommonUtils.object2Long(params.get("billid"));
        return billId;
    }

    private QFilter getPurlistFilter() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long projectId = PdsCommonUtils.object2Long(params.get("projectid"));
        long supplierId = PdsCommonUtils.object2Long(params.get("supplierid"));
        String turns = PdsCommonUtils.object2String(params.get("turns"), (String)"1");
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("supplier", "=", (Object)supplierId);
        qfilter.and("turns", "=", (Object)turns);
        qfilter.and("billtype", "=", (Object)"2");
        return qfilter;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
    }
}

