/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.pds.common.edit.AbstractBillImportEdit;
import kd.scm.pds.common.enums.SrcVieReduceTypeEnum;
import kd.scm.pds.common.util.PdsMetadataUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;

public class TndVieOnlineExportEdit
extends AbstractBillImportEdit {
    protected String getEntryKey() {
        return "entryentity";
    }

    protected void addUniqueColumn(List<String> uniqueColumnList) {
        super.addUniqueColumn(uniqueColumnList);
        uniqueColumnList.add("srcentryid");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = ((AbstractOperate)args.getSource()).getOperateKey();
        args.setCancel(true);
        switch (opKey) {
            case "export": {
                this.exportData();
                break;
            }
        }
    }

    protected void addCellRangeList(Map<String, List<String>> cellRangeListMap) {
        super.addCellRangeList(cellRangeListMap);
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(SrcVieReduceTypeEnum.PROPORTION.getName());
        resultList.add(SrcVieReduceTypeEnum.AMOUNT.getName());
        cellRangeListMap.put("reducetype", resultList);
    }

    protected boolean isAddNew() {
        return false;
    }

    protected void setColumn(ExcelDataEntity excelDataEntity) {
        super.setColumn(excelDataEntity);
        ArrayList<String> columnKeys = new ArrayList<String>(excelDataEntity.getColumnKeyList());
        columnKeys.add("srcentryid");
        DynamicObject obj = this.getModel().getDataEntity();
        String taxType = obj.getString("taxtype");
        if (Objects.equals("1", taxType)) {
            columnKeys.remove("amount");
            columnKeys.remove("price");
        } else if (Objects.equals("2", taxType)) {
            columnKeys.remove("taxamount");
            columnKeys.remove("taxprice");
        }
        if (!obj.getBoolean("isopenrank")) {
            columnKeys.remove("rank");
        }
        columnKeys.remove("adjust");
        excelDataEntity.setColumnKeyList(columnKeys);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getControl("import");
        if (null != button) {
            button.addUploadListener((UploadListener)this);
        }
    }

    protected Object getVal(String column, int index, Object val, StringBuilder msg) {
        String taxType = this.getModel().getDataEntity().getString("taxtype");
        if (Objects.equals("1", taxType) ? Objects.equals(column, "taxprice") : Objects.equals("2", taxType) && Objects.equals(column, "price")) {
            return super.getVal(column, index, val, msg);
        }
        if ("reducetype".equals(column)) {
            SrcVieReduceTypeEnum result = SrcVieReduceTypeEnum.fromName((String)String.valueOf(val));
            if (null == result) {
                IDataEntityProperty pro = this.getModel().getDataEntityType().findProperty(column);
                msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u503c\u5f55\u5165\u4e0d\u6b63\u786e\u3002", (String)"TndVieOnlineExportEdit_11", (String)"scm-tnd-formplugin", (Object[])new Object[0]), pro.getDisplayName())).append('\n');
                return result;
            }
            return result.getValue();
        }
        if (Objects.equals(column, "note")) {
            if (Objects.isNull(val)) {
                return null;
            }
            String note = val.toString();
            if (note.length() > 255) {
                IDataEntityProperty pro = this.findPro(column);
                msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255\u5b57\u8282\u3002", (String)"TndVieOnlineExportEdit_0", (String)"scm-tnd-formplugin", (Object[])new Object[0]), pro.getDisplayName()));
                msg.append('\n');
                return null;
            }
            return super.getVal(column, index, val, msg);
        }
        if (Objects.equals(column, "taxitem")) {
            return super.getVal(column, index, val, msg);
        }
        if (Objects.equals(column, "vieratio")) {
            return super.getVal(column, index, val, msg);
        }
        if (Objects.equals(column, "viediffer")) {
            return super.getVal(column, index, val, msg);
        }
        return null;
    }

    protected DynamicObject getCurrency(int index) {
        Object curr = this.getModel().getValue("currency", index - 1);
        return Objects.isNull(curr) ? null : (DynamicObject)curr;
    }

    private Object getTaxItem(Object val, String bdKey) {
        Object taxItemId = 0L;
        try {
            val = new BigDecimal(String.valueOf(val));
        }
        catch (NumberFormatException e) {
            return taxItemId;
        }
        QFilter filter = new QFilter("taxrate", "=", val);
        DynamicObject obj = QueryServiceHelper.queryOne((String)bdKey, (String)"id", (QFilter[])new QFilter[]{filter});
        if (null != obj) {
            taxItemId = obj.get("id");
        }
        return taxItemId;
    }

    protected Object getBdVal(String column, String bdKey, Object val) {
        if (column.equals("taxitem")) {
            return this.getTaxItem(val, bdKey);
        }
        return super.getBdVal(column, bdKey, val);
    }

    public Object getRowVal(DynamicObject col, String column, int index) {
        Object val = "";
        Object columnVal = null;
        if ("project".equals(column)) {
            DynamicObject project = col.getDynamicObject(column);
            if (project != null) {
                val = project.get("bidname");
            }
        } else if ("reducetype".equals(column)) {
            val = SrcVieReduceTypeEnum.getNameByValue((String)col.getString(column));
        } else {
            try {
                columnVal = col.get(column);
            }
            catch (Exception e) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u503c\u5931\u8d25\uff1a%1$s", (String)"TndVieOnlineExportEdit_10", (String)"scm-tnd-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            if (Objects.nonNull(columnVal)) {
                if (columnVal instanceof DynamicObject) {
                    if (column.equals("material")) {
                        val = ((DynamicObject)columnVal).get("number");
                    } else if ("unit".equals(column)) {
                        val = ((DynamicObject)columnVal).get("name");
                    } else if (Objects.equals("currency", column)) {
                        val = ((DynamicObject)columnVal).get("name");
                    } else if (column.equals("taxitem")) {
                        val = ((DynamicObject)columnVal).getBigDecimal("taxrate");
                        val = ((BigDecimal)val).stripTrailingZeros().toPlainString();
                    }
                } else if (columnVal instanceof BigDecimal) {
                    DynamicObject currObj = col.getDynamicObject("currency");
                    switch (column) {
                        case "qty": {
                            val = this.setQtyScaleByUnit(col.getLong("unit.id"), (BigDecimal)columnVal);
                            break;
                        }
                        case "price": 
                        case "taxprice": {
                            val = this.setPriceScaleByCurr(currObj, (BigDecimal)columnVal);
                            break;
                        }
                        case "amount": 
                        case "taxamount": {
                            val = this.setAmountScaleByCurr(currObj, (BigDecimal)columnVal);
                            break;
                        }
                    }
                } else {
                    val = columnVal instanceof Boolean ? (((Boolean)columnVal).booleanValue() ? ResManager.loadKDString((String)"\u662f", (String)"TndVieOnlineExportEdit_2", (String)"scm-tnd-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"TndVieOnlineExportEdit_3", (String)"scm-tnd-formplugin", (Object[])new Object[0])) : (columnVal instanceof Date ? DateUtil.date2str((Date)((Date)columnVal), (String)"yyyy-MM-dd HH:mm:ss") : columnVal);
                }
            }
        }
        return val;
    }

    protected void setExcelHeader(ExcelDataEntity excelDataEntity, IDataModel model) throws IOException {
        HashMap<String, String> mustInputProMap = new HashMap<String, String>(8);
        mustInputProMap.put("entryentity.price", ResManager.loadKDString((String)"\u62a5\u4ef7\u5206\u5f55.\u672a\u7a0e\u5355\u4ef7", (String)"TndVieOnlineExportEdit_4", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
        mustInputProMap.put("entryentity.taxprice", ResManager.loadKDString((String)"\u62a5\u4ef7\u5206\u5f55.\u542b\u7a0e\u5355\u4ef7", (String)"TndVieOnlineExportEdit_5", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
        mustInputProMap.put("entryentity.taxitem", ResManager.loadKDString((String)"\u62a5\u4ef7\u5206\u5f55.\u7a0e\u7387", (String)"TndVieOnlineExportEdit_6", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
        ArrayList<String> columnTitleList = new ArrayList<String>();
        Integer rowCount = 0;
        ArrayList<Integer> mustInputIndexList = new ArrayList<Integer>();
        Map proMap = PdsMetadataUtil.getProMap((String)excelDataEntity.getEntityKey(), (boolean)false);
        proMap.put("entryentity.srcentryid", ResManager.loadKDString((String)"\u8bc4\u5206\u5206\u5f55.\u660e\u7ec6ID", (String)"TndVieOnlineExportEdit_7", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
        for (int i = 0; i < excelDataEntity.getColumnKeyList().size(); ++i) {
            String column = (String)excelDataEntity.getColumnKeyList().get(i);
            String proName = proMap.getOrDefault(excelDataEntity.getEntryKey() + "." + column, ResManager.loadKDString((String)".\u672a\u5b9a\u4e49", (String)"TndVieOnlineExportEdit_8", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
            if (StringUtils.isBlank((String)proName)) continue;
            StringBuilder headTitileSb = new StringBuilder();
            String configKey = this.getEntryKey() + "." + column;
            if (null != mustInputProMap.get(configKey)) {
                headTitileSb.append('*');
                mustInputIndexList.add(rowCount);
            } else if ("srcentryid".equals(column)) {
                headTitileSb.append(ResManager.loadKDString((String)"*(\u52ff\u6539\u52ff\u5220)", (String)"TndVieOnlineExportEdit_9", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                mustInputIndexList.add(rowCount);
            }
            String[] proNames = proName.split("\\.");
            headTitileSb.append(proNames[1]);
            if (excelDataEntity.isAddColumnKeyToHeader()) {
                headTitileSb.append("${");
                headTitileSb.append(column);
                headTitileSb.append('}');
            }
            columnTitleList.add(headTitileSb.toString());
            Integer n = rowCount;
            Integer n2 = rowCount = Integer.valueOf(rowCount + 1);
        }
        excelDataEntity.setExcelHeader(columnTitleList);
        this.setColumnTitleColor(excelDataEntity, mustInputIndexList);
    }

    protected void setColumnTitleColor(ExcelDataEntity excelDataEntity, List<Integer> mustInputIndexList) {
        CellStyle style = this.getCellStyle(excelDataEntity);
        for (int colIndex : mustInputIndexList) {
            if (colIndex <= 0) continue;
            try {
                excelDataEntity.setStyle(0, 0, colIndex, style, 4000);
            }
            catch (IOException e) {
                BizLog.log((String)e.getMessage());
            }
        }
    }

    protected CellStyle getCellStyle(ExcelDataEntity excelDataEntity) {
        CellStyle style = excelDataEntity.getWorkbook().createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.GENERAL);
        Font font = excelDataEntity.getWorkbook().createFont();
        font.setColor(IndexedColors.RED.getIndex());
        style.setFont(font);
        return style;
    }

    private BigDecimal setAmountScaleByCurr(DynamicObject unitObj, BigDecimal amount) {
        return Objects.isNull(unitObj) ? amount : amount.setScale(unitObj.getInt("amtprecision"), RoundingMode.HALF_UP);
    }

    private BigDecimal setPriceScaleByCurr(DynamicObject unitObj, BigDecimal amount) {
        return Objects.isNull(unitObj) ? amount : amount.setScale(unitObj.getInt("priceprecision"), RoundingMode.HALF_UP);
    }

    private BigDecimal setQtyScaleByUnit(Object unitPk, BigDecimal qty) {
        DynamicObject unitObj = BusinessDataServiceHelper.loadSingle((Object)unitPk, (String)"bd_measureunits");
        if (Objects.isNull(unitObj)) {
            return qty;
        }
        return this.setScaleByUnit(unitObj, qty);
    }

    private BigDecimal setScaleByUnit(DynamicObject unitObj, BigDecimal oldValue) {
        RoundingMode roundingMode;
        String precisionAccount;
        if (BigDecimal.ZERO.compareTo(oldValue) == 0) {
            return BigDecimal.ZERO;
        }
        int scale = unitObj.getInt("precision");
        switch (precisionAccount = unitObj.getString("precisionaccount")) {
            case "2": {
                roundingMode = RoundingMode.DOWN;
                break;
            }
            case "3": {
                roundingMode = RoundingMode.UP;
                break;
            }
            default: {
                roundingMode = RoundingMode.HALF_UP;
            }
        }
        return oldValue.setScale(scale, roundingMode);
    }

    protected int getScale(String column) {
        int scale;
        switch (column) {
            case "score": 
            case "scorerscore": 
            case "sysscore": {
                scale = 4;
                break;
            }
            case "indexweight": 
            case "threshold": 
            case "scorerweight": {
                scale = 2;
                break;
            }
            default: {
                scale = 6;
            }
        }
        return scale;
    }
}

