/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.filter;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.extfilter.IExtFilterPlugin;
import kd.scm.pds.common.util.PdsCommonUtils;

public class TndProjectCategoryFilter
implements IExtFilterPlugin<ExtFilterContext> {
    public Map<String, Object> getQFilter(ExtFilterContext context) {
        Set<Long> categorySet = this.getCategorySet();
        Set<Long> projectSet = this.getProjectSet(categorySet);
        QFilter qfilter = new QFilter("id", "in", projectSet);
        return this.getQFilterMap(qfilter, null);
    }

    protected Set<Long> getCategorySet() {
        List supplierList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        QFilter categoryFilter = new QFilter("supplier.supplier.id", "in", (Object)supplierList);
        categoryFilter.and("auditstatus", "=", (Object)"1");
        String selectFields = "category.id";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"srm_supcategory", (String)selectFields, (QFilter[])categoryFilter.toArray());
        if (rows == null || rows.size() == 0) {
            return null;
        }
        return rows.stream().map(e -> e.getLong("category.id")).collect(Collectors.toSet());
    }

    protected Set<Long> getProjectSet(Set<Long> categorySet) {
        if (categorySet == null || categorySet.size() == 0) {
            return null;
        }
        QFilter projectFilter = new QFilter("category.id", "in", categorySet);
        projectFilter.and("entrystatus", "=", (Object)ProjectStatusEnums.TOQUOTE.getValue());
        String selectFields = "project.id";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields, (QFilter[])projectFilter.toArray());
        if (rows == null || rows.size() == 0) {
            return null;
        }
        return rows.stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
    }
}

