/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.list;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.scm.common.plugin.AbstractTndListPlugin;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.common.util.TndProjectTaskUtils;
import kd.scm.tnd.formplugin.list.TndProjectListHandler;

public class TndProjectList
extends AbstractTndListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        this.openProjectTask(args);
    }

    private void openProjectTask(AfterDoOperationEventArgs args) {
        String taskOpKey = args.getOperateKey();
        if (!TndProjectTaskUtils.getProjetTaskOpSet().contains(taskOpKey)) {
            return;
        }
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow row = list.getCurrentSelectedRowInfo();
        long projectId = PdsCommonUtils.object2Long((Object)row.getPrimaryKeyValue());
        if (projectId == 0L) {
            return;
        }
        String totoTaskStr = this.getView().getPageCache().get(String.valueOf(row.getPrimaryKeyValue()));
        if (null == totoTaskStr) {
            return;
        }
        Map todoTaskMap = TndProjectTaskUtils.getTodoTaskMap((String)totoTaskStr.toString());
        TndProjectTaskUtils.openProjectTask((IFormView)this.getView(), (String)this.getPluginName(), (String)taskOpKey, (long)((Long)todoTaskMap.get(taskOpKey)), (String)"billno");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter inviteFilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"tnd_project", (IFormView)this.getView(), null);
        QFilter openFilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"tnd_apply", (IFormView)this.getView(), null);
        QFilter qfilter = inviteFilter.or(openFilter);
        qFilters.add(qfilter);
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc && "taskhandleop".equals(((ListOperationColumnDesc)e.getSource()).getKey())) {
            HashMap<String, String> taskMap = new HashMap<String, String>();
            taskMap.put(String.valueOf(e.getRowData().getLong("id")), e.getRowData().getString("todotask"));
            this.getView().getPageCache().put(taskMap);
            Map todoTaskMap = TndProjectTaskUtils.getTodoTaskMap((String)e.getRowData().getString("todotask"));
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                if (null != todoTaskMap.get(operationColItem.getOperationKey())) {
                    operationColItem.setVisible(true);
                    continue;
                }
                operationColItem.setVisible(false);
            }
        }
        super.packageData(e);
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            TndProjectListHandler handler = (TndProjectListHandler)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(TndProjectListHandler.class.getSimpleName(), null);
            if (null == handler) {
                return rows;
            }
            return handler.handleNodeStatus(rows);
        }
    }
}

