/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.analysesum;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.monitor.Monitor;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.common.util.MetadataUtils;

public class OverdueQueryHelper {
    public DataSet queryOverdueBills(CreditScheme scheme, Dimension dimension, Collection<DimensionValue> dimensionValues, BillStrategy billStrategy, List<String> extSelectors) {
        String quotaType;
        String assingEntityKey = billStrategy.getAssingEntityKey();
        String calculateDate = billStrategy.getCalculateDate();
        String calculateAmt = billStrategy.getCalculateAmt();
        EntityConfig entityConfig = new CreditServiceFacade().getConfig(assingEntityKey);
        List<Long> orgScopes = scheme.getOrgScopes();
        LinkedList<String> selectors = new LinkedList<String>();
        QFilter filter = new QFilter(calculateDate, "is not null", null);
        filter.and(new QFilter(calculateDate, "<", (Object)DateUtils.getStartOfDay((Date)new Date())));
        if (orgScopes != null && orgScopes.size() > 0) {
            Field orgField = entityConfig.getOrgField();
            String orgFieldKey = orgField.getKey();
            if (orgField.getEntryKey() != null) {
                orgFieldKey = orgField.getEntryKey() + "." + orgField.getKey();
            }
            filter.and(new QFilter(orgFieldKey, "in", orgScopes));
        }
        if ("overdueamt".equals(quotaType = scheme.getQuotaType().getQuotaType()) && scheme.isSingleCurrencyControl()) {
            Field currencyField = entityConfig.getField(CreditElement.ELEMENT_CURRENCY);
            String currencyFilterKey = currencyField.getKey();
            if (currencyField.getEntryKey() != null) {
                currencyFilterKey = currencyField.getEntryKey() + "." + currencyField.getKey();
            }
            filter.and(new QFilter(currencyFilterKey, "=", (Object)scheme.getCurrency()));
        }
        List<Role> roles = dimension.getRoles();
        Long cusunicodeId = 0L;
        int roleIndex = 0;
        for (Role role : roles) {
            String roleType = role.getRoleType();
            Field roleField = entityConfig.getRoleField(roleType);
            if (roleField == null) {
                String entityKey = entityConfig.getEntityKey();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
                String string = dataEntityType.getDisplayName().getLocaleValue();
                String messageTemplate = ResManager.loadKDString((String)"\u903e\u671f\u5355\u636e\u201c%1$s\u201d\u6ca1\u6709\u914d\u7f6e\u201c%2$s\u201d\u7ef4\u5ea6\u7684\u5b57\u6bb5\u6620\u5c04\uff0c\u8bf7\u524d\u5f80\u201c\u5355\u636e\u6ce8\u518c\u201d\u754c\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"OverdueQueryHelper_0", (String)"scmc-ccm-report", (Object[])new Object[0]);
                throw new KDBizException(String.format(messageTemplate, string, role.getRoleName()));
            }
            HashSet<Long> roleIds = new HashSet<Long>(dimensionValues.size());
            for (DimensionValue dimensionValue : dimensionValues) {
                Object value = dimensionValue.getValue(role);
                if ("CUSUNICODE".equals(roleType)) {
                    cusunicodeId = Long.valueOf(String.valueOf(value));
                    continue;
                }
                roleIds.add(Long.valueOf(value.toString()));
            }
            if (cusunicodeId != 0L) {
                DynamicObjectCollection cusunicodes = QueryServiceHelper.query((String)"ccm_cusunicode", (String)"entry.e_customer", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cusunicodeId)});
                for (DynamicObject cusunicode : cusunicodes) {
                    roleIds.add(cusunicode.getLong("entry.e_customer"));
                }
            }
            String roleFieldKey = roleField.getKey();
            String string = role.getBasedataEntityKey();
            MainEntityType roleBDEntityType = MetadataServiceHelper.getDataEntityType((String)string);
            if (roleBDEntityType != null && roleBDEntityType.findProperty("masterid") != null) {
                MainEntityType assEntityType = MetadataServiceHelper.getDataEntityType((String)assingEntityKey);
                if (assEntityType.getProperty(roleField.getKey()) instanceof BigIntProp) {
                    QFilter q = new QFilter("masterid", "in", roleIds);
                    DynamicObjectCollection roleIdCollection = QueryServiceHelper.query((String)string, (String)"id", (QFilter[])new QFilter[]{q});
                    if (roleIdCollection != null && !roleIdCollection.isEmpty()) {
                        HashSet roleIdsNew = new HashSet(16);
                        roleIdCollection.stream().forEach(roleValue -> roleIdsNew.add(roleValue.getLong("id")));
                        roleIds.clear();
                        roleIds.addAll(roleIdsNew);
                    }
                } else {
                    roleFieldKey = roleFieldKey + ".masterid";
                }
            }
            if (roleField.getEntryKey() == null) {
                filter.and(new QFilter(roleFieldKey, "in", roleIds));
                selectors.add(roleFieldKey + " as role" + roleIndex);
            } else {
                filter.and(new QFilter(roleField.getEntryKey() + "." + roleFieldKey, "in", roleIds));
                selectors.add(roleField.getEntryKey() + "." + roleFieldKey + " as role" + roleIndex);
            }
            ++roleIndex;
        }
        if (StringUtils.isEmpty((CharSequence)calculateAmt)) {
            selectors.add(calculateDate + " as calculateDate");
        } else {
            selectors.add(calculateAmt + " as calculateAmt");
        }
        Field currencyField = entityConfig.getField(CreditElement.ELEMENT_CURRENCY);
        String currencyFilterKey = currencyField.getKey();
        selectors.add(currencyFilterKey + " as billcurrency");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)assingEntityKey);
        if (dataEntityType != null && dataEntityType.getProperty("billno") != null) {
            selectors.add("billno as billno");
        } else {
            selectors.add("'' as billno");
        }
        String overdueEntry = null;
        String prefix = !StringUtils.isEmpty((CharSequence)calculateAmt) ? calculateAmt.split("[.]")[0] : calculateDate.split("[.]")[0];
        if (dataEntityType != null) {
            List entryProps = MetadataUtils.getEntryProps((IDataEntityType)dataEntityType);
            for (EntryProp entryProp : entryProps) {
                if (!Objects.equals(entryProp.getName(), prefix)) continue;
                overdueEntry = prefix;
                break;
            }
        }
        if (overdueEntry != null) {
            selectors.add(overdueEntry + ".seq as entryseq");
        } else {
            selectors.add("1 as entryseq");
        }
        Expression expression = billStrategy.getExpression();
        if (!ObjectUtils.isEmpty((Object)expression.getCondition().getCondition())) {
            FilterCondition filterCondition = expression.getCondition().getCondition().getFilterCondition();
            FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
            filterBuilder.buildFilter();
            filter.and(filterBuilder.getQFilter());
        }
        selectors.addAll(extSelectors);
        HashSet hashSet = new HashSet(selectors.size());
        selectors.stream().forEach(selector -> duplicateRemovalSelector.add(selector));
        Monitor.getDebugDetail(scheme).info(this.getClass(), "filter=", filter.toString());
        return QueryServiceHelper.queryDataSet((String)"ccm.OverdueQueryHelper.queryoverdueday", (String)assingEntityKey, (String)String.join((CharSequence)",", hashSet), (QFilter[])new QFilter[]{filter}, null);
    }
}

