/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.archives;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.scmc.ccm.common.util.OrmFacade;

public class ArchiveEffectService {
    private OrmFacade ormFacade = new OrmFacade();

    public void effect(DataSet dataSet) {
        LinkedList<Long> archiveIds = new LinkedList<Long>();
        for (Row row : dataSet) {
            if (!"NOEFFECT".equals(row.getString("effectstate"))) continue;
            archiveIds.add(row.getLong("id"));
        }
        DynamicObject[] archives = this.ormFacade.load("ccm_archive", "scheme,dimensionvalue,balance,increasesum,reducesum,effectstate,relatedid", new QFilter[]{new QFilter("id", "in", archiveIds)});
        this.effect(archives);
    }

    public void effect(DynamicObject[] archives) {
        ArrayList<DynamicObject> noEffectArchives = new ArrayList<DynamicObject>(archives.length);
        HashSet<Long> noEffectRelatedIds = new HashSet<Long>(archives.length);
        for (DynamicObject archive : archives) {
            String effectState = archive.getString("effectstate");
            if (!"NOEFFECT".equals(effectState)) continue;
            noEffectArchives.add(archive);
            noEffectRelatedIds.add(archive.getLong("relatedid"));
        }
        if (noEffectArchives.size() == 0) {
            return;
        }
        QFilter isEffectedArchiveFilter = new QFilter("relatedid", "in", noEffectRelatedIds);
        isEffectedArchiveFilter.and(new QFilter("effectstate", "=", (Object)"ISEFFECT"));
        DynamicObject[] isEffectdArchives = this.ormFacade.load("ccm_archive", "scheme,dimensionvalue,balance,increasesum,reducesum,effectstate,relatedid", new QFilter[]{isEffectedArchiveFilter});
        ArrayList<DynamicObject> isEffectedArchiveList = new ArrayList<DynamicObject>(archives.length);
        ArrayList<DynamicObject> onlyEffectArchiveList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> noEffectedArchiveList = new ArrayList<DynamicObject>(16);
        for (DynamicObject noEffectArchive : noEffectArchives) {
            DynamicObject isEffectedArchive = this.matchIsEffectedArchive(isEffectdArchives, noEffectArchive);
            if (isEffectedArchive == null) {
                noEffectArchive.set("effectstate", (Object)"ISEFFECT");
                onlyEffectArchiveList.add(noEffectArchive);
                continue;
            }
            noEffectArchive.set("increasesum", (Object)isEffectedArchive.getBigDecimal("increasesum"));
            noEffectArchive.set("reducesum", (Object)isEffectedArchive.getBigDecimal("reducesum"));
            BigDecimal balance = noEffectArchive.getBigDecimal("balance").add(isEffectedArchive.getBigDecimal("increasesum").subtract(isEffectedArchive.getBigDecimal("reducesum")));
            noEffectArchive.set("balance", (Object)balance);
            noEffectArchive.set("effectstate", (Object)"ISEFFECT");
            noEffectedArchiveList.add(noEffectArchive);
            isEffectedArchiveList.add(isEffectedArchive);
        }
        for (DynamicObject isEffectedArchive : isEffectedArchiveList) {
            isEffectedArchive.set("effectstate", (Object)"EXPRIED");
        }
        this.ormFacade.update(isEffectedArchiveList.toArray(new DynamicObject[0]));
        if (onlyEffectArchiveList.size() > 0) {
            this.ormFacade.update(onlyEffectArchiveList.toArray(new DynamicObject[0]));
        }
        if (noEffectedArchiveList.size() > 0) {
            this.ormFacade.update(noEffectedArchiveList.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject matchIsEffectedArchive(DynamicObject[] isEffectdArchives, DynamicObject noEffectArchive) {
        for (DynamicObject isEffectedArchive : isEffectdArchives) {
            if (noEffectArchive.getLong("relatedid") != isEffectedArchive.getLong("relatedid")) continue;
            return isEffectedArchive;
        }
        return null;
    }
}

