/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.archives;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.setting.DimensionValueControlledHelper;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.common.util.OrmFacade;

public class ArchiveGenerator {
    private DimensionValueControlledHelper dimensionValueHelper = new DimensionValueControlledHelper();
    private OrmFacade ormFacade = new OrmFacade();

    public DynamicObject[] autoGenerate(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        DynamicObject rawScheme = scheme.getRawScheme();
        String validity = rawScheme.getString("validity");
        List<DimensionValue> controlledDimensionValues = this.dimensionValueHelper.getControlledDimensionValues(scheme, dimensionValues);
        ArrayList<String> dimensionValueList = new ArrayList<String>(controlledDimensionValues.size());
        ArrayList<DynamicObject> archiveList = new ArrayList<DynamicObject>(controlledDimensionValues.size());
        long[] archiveIds = DB.genLongIds((String)"ccm_archive", (int)controlledDimensionValues.size());
        int archiveIdIndex = 0;
        Date today = DateUtils.getStartOfDay((Date)new Date());
        DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(scheme.getDimension().getId());
        for (DimensionValue dimensionValue : controlledDimensionValues) {
            DynamicObject[] archive = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ccm_archive"));
            dimensionValueList.add(dimensionValue.getValue());
            archive.set("id", (Object)archiveIds[archiveIdIndex]);
            archive.set("relatedid", (Object)archiveIds[archiveIdIndex]);
            archive.set("scheme", (Object)scheme.getId());
            archive.set("dimensionvalue", (Object)dimensionValue.getValue());
            archive.set("archivetype", (Object)"normal");
            archive.set("dimension", (Object)scheme.getDimension().getId());
            String quotaType = scheme.getQuotaType().getQuotaType();
            archive.set("quotatype", (Object)quotaType);
            if ("amount".equals(quotaType)) {
                archive.set("unit", (Object)scheme.getCurrency());
                archive.set("quota", (Object)rawScheme.getBigDecimal("defaultquota"));
                archive.set("balance", (Object)rawScheme.getBigDecimal("defaultquota"));
            }
            if ("days".equals(quotaType)) {
                archive.set("quota", (Object)rawScheme.getBigDecimal("defaultdays"));
                archive.set("balance", (Object)rawScheme.getBigDecimal("defaultdays"));
            }
            if ("PERPETUAL".equals(validity)) {
                archive.set("begindate", (Object)today);
                archive.set("enddate", (Object)DateUtils.getEndOfDay((Date)DateUtils.getYearsLaterDate((Date)today, (int)100)));
                archive.set("effectstate", (Object)"ISEFFECT");
            } else {
                archive.set("effectstate", (Object)"NOEFFECT");
                Date yearBeginDate = rawScheme.getDate("yearbegindate");
                Date beginDate = DateUtils.getSpecialDate((int)DateUtils.getDateYear((Date)today), (int)DateUtils.getDateMonth((Date)yearBeginDate), (int)DateUtils.getDateDay((Date)yearBeginDate));
                if (DateUtils.getStartOfDay((Date)beginDate).compareTo(today) > 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(beginDate);
                    calendar.set(1, calendar.get(1) - 1);
                    beginDate = calendar.getTime();
                }
                archive.set("begindate", (Object)DateUtils.getStartOfDay((Date)beginDate));
                archive.set("enddate", (Object)DateUtils.getEndOfDay((Date)DateUtils.getYearsLaterDate((Date)beginDate, (int)1)));
            }
            ++archiveIdIndex;
            List<Role> roles = dimensionValue.getDimension().getRoles();
            List<String> roleFieldKeys = mapper.getRoleFieldKeys();
            for (int i = 0; i < roleFieldKeys.size(); ++i) {
                archive.set(roleFieldKeys.get(i), dimensionValue.getValue(roles.get(i)));
            }
            List<String> fieldTypeKeys = mapper.getFieldTypeKeys();
            for (String fieldTypeKey : fieldTypeKeys) {
                archive.set(fieldTypeKey, (Object)mapper.getBaseDataKey(fieldTypeKey));
            }
            archiveList.add((DynamicObject)archive);
        }
        if (!ObjectUtils.isEmpty(archiveList)) {
            if ("YEAR".equals(validity)) {
                this.setRelatedId(archiveList, rawScheme.getLong("id"), dimensionValueList);
            }
            DynamicObject[] archives = (DynamicObject[])this.ormFacade.save(archiveList.toArray(new DynamicObject[0]));
            ArrayList<Long> successArchiveIds = new ArrayList<Long>(archives.length);
            for (DynamicObject archive : archives) {
                successArchiveIds.add(archive.getLong("id"));
            }
            DynamicObject[] successArchives = this.ormFacade.load("ccm_archive", "billno,scheme,dimension,dimensionvalue,unit,quota,archivetype,quotatype,balance,begindate,enddate,increasesum,reducesum,effectstate,relatedid", new QFilter[]{new QFilter("id", "in", successArchiveIds)});
            return successArchives;
        }
        return null;
    }

    private void setRelatedId(List<DynamicObject> archiveList, long schemeId, List<String> dimensionValueList) {
        DynamicObject[] archives = this.ormFacade.load("ccm_archive", "scheme,dimensionvalue,relatedid", new QFilter[]{new QFilter("scheme", "=", (Object)schemeId), new QFilter("dimensionvalue", "in", dimensionValueList)});
        for (DynamicObject dest : archiveList) {
            DynamicObject archive = this.matchArchive(archives, dest);
            if (archive == null) {
                dest.set("relatedid", (Object)dest.getLong("id"));
                continue;
            }
            dest.set("relatedid", (Object)archive.getLong("relatedid"));
        }
    }

    private DynamicObject matchArchive(DynamicObject[] archives, DynamicObject dest) {
        for (DynamicObject archive : archives) {
            if (!archive.getString("dimensionvalue").equals(dest.getString("dimensionvalue"))) continue;
            return archive;
        }
        return null;
    }
}

