/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.archives;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.core.Direction;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;

public class ArchiveService {
    private static final Log logger = LogFactory.getLog(ArchiveService.class);

    public CheckResult updateBalance(JournalGroup journalGroup, ArchiveCollection archives, boolean isReverse) {
        long begintime = System.currentTimeMillis();
        logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97 begin \uff1a" + new Date(begintime));
        logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97 isReverse \uff1a" + isReverse);
        for (Journal journal : journalGroup.getJournals()) {
            if (journal == null) {
                logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  journal is null!");
                continue;
            }
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  journal getBillNo\uff1a" + journal.getBillNo());
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  journal getAction\uff1a" + journal.getAction());
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  journal getDirection\uff1a" + journal.getDirection());
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  journal getOp\uff1a" + journal.getOp());
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  journal getAmount\uff1a" + journal.getAmount());
            CreditArchive archive = (CreditArchive)archives.get(journal.getDimensionValue());
            if (archive == null) continue;
            int precision = journal.getUnitPrecision();
            DynamicObject mainArchive = archive.getMainArchive();
            journal.setArchiveId(mainArchive.getLong("id"));
            BigDecimal balance = mainArchive.getBigDecimal("balance");
            BigDecimal reduceSum = mainArchive.getBigDecimal("reducesum");
            BigDecimal increaseSum = mainArchive.getBigDecimal("increasesum");
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u6863\u6848ID archiveID\uff1a" + archive.getId());
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u4e3b\u6863ID mainArchiveID\uff1a" + mainArchive.getLong("id"));
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u4e3b\u6863\u4f59\u989d mainArchive.balance\uff1a" + balance);
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u4e3b\u6863\u5360\u7528 mainArchive.reduceSum\uff1a" + reduceSum);
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u4e3b\u6863\u8fd4\u8fd8mainArchive.increaseSum\uff1a" + increaseSum);
            if (Objects.equals(journal.getDirection(), Direction.REDUCE.name())) {
                logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u65b9\u5411\uff1a\u5360\u7528");
                if (isReverse) {
                    logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u65b9\u5411\uff1a\u5360\u7528\u53cd\u5411\u64cd\u4f5c");
                    logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u6863\u6848 archive.balance = archive.balance(" + archive.getBalance() + ") + journal.Amount( " + journal.getAmount() + ")");
                    archive.increaseBalance(journal.getAmount().setScale(precision, 4));
                    logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u6863\u6848 archive.newbalance: " + archive.getBalance());
                    mainArchive.set("balance", (Object)balance.add(journal.getAmount()).setScale(precision, 4));
                    mainArchive.set("reducesum", (Object)reduceSum.subtract(journal.getAmount()).setScale(precision, 4));
                } else {
                    logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u65b9\u5411\uff1a\u5360\u7528\u6b63\u5411\u64cd\u4f5c");
                    logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u6863\u6848 archive.balance = archive.balance(" + archive.getBalance() + ") - journal.Amount( " + journal.getAmount() + ")");
                    archive.reduceBalance(journal.getAmount().setScale(precision, 4));
                    logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u6863\u6848 archive.newbalance: " + archive.getBalance());
                    mainArchive.set("balance", (Object)balance.subtract(journal.getAmount()).setScale(precision, 4));
                    mainArchive.set("reducesum", (Object)reduceSum.add(journal.getAmount()).setScale(precision, 4));
                }
                logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u4e3b\u6863\u4f59\u989d mainArchive.newbalance\uff1a" + mainArchive.getBigDecimal("balance"));
                logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u4e3b\u6863\u5360\u7528 mainArchive.newreduceSum\uff1a" + mainArchive.getBigDecimal("reducesum"));
                continue;
            }
            if (isReverse) {
                logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u65b9\u5411\uff1a\u8fd4\u8fd8\u53cd\u5411\u64cd\u4f5c");
                logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u6863\u6848 archive.balance = archive.balance(" + archive.getBalance() + ") - journal.Amount( " + journal.getAmount() + ")");
                archive.reduceBalance(journal.getAmount().setScale(precision, 4));
                logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u6863\u6848 archive.newbalance: " + archive.getBalance());
                mainArchive.set("balance", (Object)balance.subtract(journal.getAmount()).setScale(precision, 4));
                mainArchive.set("increasesum", (Object)increaseSum.subtract(journal.getAmount()).setScale(precision, 4));
            } else {
                logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u65b9\u5411\uff1a\u8fd4\u8fd8\u53cd\u5411\u64cd\u4f5c");
                logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u6863\u6848 archive.balance = archive.balance(" + archive.getBalance().setScale(precision, 4) + ") + journal.Amount( " + journal.getAmount() + ")");
                archive.increaseBalance(journal.getAmount().setScale(precision, 4));
                logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u6863\u6848 archive.newbalance: " + archive.getBalance().setScale(precision, 4));
                mainArchive.set("balance", (Object)balance.add(journal.getAmount()).setScale(precision, 4));
                mainArchive.set("increasesum", (Object)increaseSum.add(journal.getAmount()).setScale(precision, 4));
            }
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u4e3b\u6863\u4f59\u989d mainArchive.newbalance\uff1a" + mainArchive.getBigDecimal("balance"));
            logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97  \u4e3b\u6863\u5360\u7528 mainArchive.newincreasesum\uff1a" + mainArchive.getBigDecimal("increasesum"));
        }
        CheckResult checkResult = new CheckResult();
        checkResult.setSuccess(true);
        checkResult.setBillno(journalGroup.getBillNo());
        logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97 \u5355\u636e\u7f16\u53f7\uff1a{} \u7684 journalGroup.checkResult is Success! ", (Object)journalGroup.getBillNo());
        long endtime = System.currentTimeMillis();
        logger.info("\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97 end \uff1a" + new Date(endtime));
        logger.info("\u672c\u6b21\u4fe1\u7528\u6863\u6848\u4f59\u989d\u8ba1\u7b97 \u8017\u65f6 \uff1a{} ms", (Object)(endtime - begintime));
        return checkResult;
    }
}

