/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.archives;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.DimensionValueControlledHelper;
import kd.scmc.ccm.common.helper.SysParamHelper;

public class ArchiveValidator {
    private DimensionValueControlledHelper helper = new DimensionValueControlledHelper();

    public List<CheckResult> validate(Collection<JournalGroup> journalGroups, ArchiveCollection archives) {
        return this.validate(journalGroups, archives, false);
    }

    public List<CheckResult> validate(Collection<JournalGroup> journalGroups, ArchiveCollection archives, boolean isForUpdateBalanceService) {
        LinkedList<DimensionValue> dimensionValues = new LinkedList<DimensionValue>();
        LinkedList<CheckResult> results = new LinkedList<CheckResult>();
        if (journalGroups == null || archives == null || archives.getScheme() == null) {
            return results;
        }
        Boolean isctrcusunicode = (Boolean)SysParamHelper.getCCMSysParam((String)"isctrcusunicode");
        for (JournalGroup journalGroup : journalGroups) {
            for (Journal journal : journalGroup.getJournals()) {
                DimensionValue dimensionValue = journal.getDimensionValue();
                CreditArchive archive = (CreditArchive)archives.get(dimensionValue);
                if (Boolean.FALSE.equals(isctrcusunicode)) {
                    boolean isCusunicode = false;
                    if (dimensionValue != null) {
                        List<Role> roles = dimensionValue.getDimension().getRoles();
                        for (Role role : roles) {
                            String roleType = role.getRoleType();
                            if (!"CUSUNICODE".equals(roleType)) continue;
                            isCusunicode = true;
                            break;
                        }
                    }
                    if (archive != null || isCusunicode) continue;
                    dimensionValues.add(dimensionValue);
                    continue;
                }
                if (archive != null) continue;
                dimensionValues.add(dimensionValue);
            }
        }
        CreditScheme scheme = archives.getScheme();
        HashSet<DimensionValue> controlledDimensionValues = new HashSet<DimensionValue>(this.helper.getControlledDimensionValues(scheme, dimensionValues));
        Iterator<JournalGroup> iterator = journalGroups.iterator();
        block3: while (iterator.hasNext()) {
            JournalGroup journalGroup = iterator.next();
            for (Journal journal : journalGroup.getJournals()) {
                if (!controlledDimensionValues.contains(journal.getDimensionValue())) continue;
                String entityKey = journalGroup.getMainEntityKey();
                CheckResult result = new CheckResult(scheme, entityKey);
                this.wrapControlResult(scheme, result, journal, isForUpdateBalanceService);
                results.add(result);
                iterator.remove();
                continue block3;
            }
        }
        return results;
    }

    private CheckResult wrapControlResult(CreditScheme scheme, CheckResult result, Journal journal, boolean isForUpdateBalanceService) {
        result.setBillno(journal.getBillNo());
        result.setSuccess(false);
        String schemeName = scheme.getRawScheme().getString("name");
        String message = ResManager.loadKDString((String)"\u4fe1\u63a7\u65b9\u6848\u201c%s\u201d\u65e0\u53ef\u7528\u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"ArchiveValidator_0", (String)"scmc-ccm-business", (Object[])new Object[0]);
        result.setMessage(String.format(message, schemeName));
        if (isForUpdateBalanceService) {
            result.setMessageType("error");
        }
        return result;
    }
}

