/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.archives;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.ArchiveEffectService;
import kd.scmc.ccm.business.archives.ArchiveGenerator;
import kd.scmc.ccm.business.archives.ArchiveLoader;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.common.util.OrmFacade;
import org.apache.commons.lang.ArrayUtils;

public class DefaultArchiveLoader
implements ArchiveLoader {
    private OrmFacade ormFacade = new OrmFacade();
    private ArchiveEffectService archiveEffectService = new ArchiveEffectService();

    @Override
    public ArchiveCollection loadArchives(CreditScheme scheme) {
        QFilter filter = new QFilter("scheme", "=", (Object)scheme.getId());
        filter.and(new QFilter("begindate", "<=", (Object)new Date()));
        filter.and(new QFilter("enddate", ">=", (Object)new Date()));
        DynamicObject[] rawArchives = this.ormFacade.load("ccm_archive", "billno,scheme,dimension,dimensionvalue,unit,quota,archivetype,quotatype,balance,begindate,enddate,increasesum,reducesum,effectstate,relatedid", new QFilter[]{filter});
        this.archiveEffectService.effect(rawArchives);
        return this.transDynamnicToArchive(scheme, rawArchives);
    }

    @Override
    public ArchiveCollection loadArchives(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        HashSet<String> plainValues = new HashSet<String>(dimensionValues.size());
        for (DimensionValue value : dimensionValues) {
            plainValues.add(value.getValue());
        }
        QFilter dimensionValueFilter = new QFilter("dimensionvalue", "in", plainValues);
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)scheme.getId());
        Date today = new Date();
        QFilter dataRangeFilter = new QFilter("begindate", "<=", (Object)DateUtils.getEndOfDay((Date)today)).and("enddate", ">=", (Object)DateUtils.getStartOfDay((Date)today));
        QFilter[] filters = null;
        filters = "PERPETUAL".equals(scheme.getValidity()) ? new QFilter[]{schemeFilter, dimensionValueFilter} : new QFilter[]{schemeFilter, dimensionValueFilter, dataRangeFilter};
        Object[] rawArchives = this.ormFacade.load("ccm_archive", "billno,scheme,dimension,dimensionvalue,unit,quota,archivetype,quotatype,balance,begindate,enddate,increasesum,reducesum,effectstate,relatedid", filters);
        Object[] autoCreatedArchives = null;
        if (!"overdueamt".equals(scheme.getQuotaType().getQuotaType())) {
            autoCreatedArchives = this.getAutoCreatedArchive(scheme, dimensionValues, (DynamicObject[])rawArchives);
        }
        if ("PERPETUAL".equals(scheme.getValidity())) {
            ArrayList<Object> copyRawArchives = new ArrayList<Object>(rawArchives.length);
            for (Object rawArchive : rawArchives) {
                Date beginDate = rawArchive.getDate("begindate");
                Date endDate = rawArchive.getDate("enddate");
                if (beginDate == null || endDate == null || DateUtils.getStartOfDay((Date)beginDate).compareTo(today) > 0 || DateUtils.getEndOfDay((Date)endDate).compareTo(today) < 0) continue;
                copyRawArchives.add(rawArchive);
            }
            rawArchives = copyRawArchives.toArray(new DynamicObject[0]);
        }
        Object[] transArchives = autoCreatedArchives == null ? rawArchives : (DynamicObject[])ArrayUtils.addAll((Object[])rawArchives, (Object[])autoCreatedArchives);
        this.archiveEffectService.effect((DynamicObject[])transArchives);
        return this.transDynamnicToArchive(scheme, (DynamicObject[])transArchives);
    }

    public ArchiveCollection transDynamnicToArchive(CreditScheme scheme, DynamicObject[] rawArchives) {
        ArchiveCollection archiveCollection = new ArchiveCollection(scheme, rawArchives.length);
        for (DynamicObject rawArchive : rawArchives) {
            this.dynamicToArchive(scheme, archiveCollection, rawArchive);
        }
        return archiveCollection;
    }

    public DynamicObjectCollection loadArchives(List<Long> schemeIds, List<String> dimensionValues) {
        QFilter schemeFilter = new QFilter("scheme", "in", schemeIds);
        QFilter dimensionValueFilter = new QFilter("dimensionvalue", "in", dimensionValues);
        QFilter[] filters = new QFilter[]{schemeFilter, dimensionValueFilter};
        DynamicObjectCollection archives = QueryServiceHelper.query((String)"ccm_archive", (String)"id,scheme,dimensionvalue,relatedid", (QFilter[])filters);
        return archives;
    }

    private void dynamicToArchive(CreditScheme scheme, ArchiveCollection archiveCollection, DynamicObject rawArchive) {
        DimensionValue dimensionValue = new DimensionValue(scheme.getDimension());
        dimensionValue.setValue(rawArchive.getString("dimensionvalue"));
        CreditArchive archive = (CreditArchive)archiveCollection.get(dimensionValue);
        if (archive == null) {
            archive = new CreditArchive();
            archive.setId(rawArchive.getLong("id"));
            archive.setScheme(scheme);
            Dimension dimension = scheme.getDimension();
            DimensionValue value = new DimensionValue(dimension);
            value.setValue(rawArchive.getString("dimensionvalue"));
            archive.setDimensionValue(value);
            archiveCollection.put(dimensionValue, archive);
        }
        String quotaType = rawArchive.getString("quotatype");
        archive.setUnit(rawArchive.getLong("unit"));
        archive.setQuotaType(quotaType);
        if ("amount".equals(quotaType) || "privilegeamt".equals(quotaType)) {
            archive.setCurrencyPrecision(scheme.getCurrencyPrecision());
        }
        archive.increaseQuota(rawArchive.getBigDecimal("quota"));
        archive.increaseBalance(rawArchive.getBigDecimal("balance"));
        archive.setOldBalance(archive.getBalance());
        archive.getRawArchives().add(rawArchive);
    }

    public DynamicObject[] getAutoCreatedArchive(CreditScheme scheme, List<DimensionValue> dimensionValues, DynamicObject[] rawArchives) {
        boolean autoCreateArchive = scheme.getRawScheme().getBoolean("autocreatearchive");
        if (autoCreateArchive) {
            HashSet<DimensionValue> plainValues = new HashSet<DimensionValue>(dimensionValues.size());
            for (DimensionValue dimensionValue : dimensionValues) {
                plainValues.add(dimensionValue);
            }
            ArrayList<DimensionValue> isCreateDimensionValues = new ArrayList<DimensionValue>(plainValues.size());
            for (DimensionValue dimensionValue : plainValues) {
                if (this.isMatchArchive(dimensionValue, scheme.getId(), rawArchives)) continue;
                isCreateDimensionValues.add(dimensionValue);
            }
            ArchiveGenerator archiveGenerator = new ArchiveGenerator();
            return archiveGenerator.autoGenerate(scheme, isCreateDimensionValues);
        }
        return null;
    }

    private boolean isMatchArchive(DimensionValue dimensionValue, long schemeId, DynamicObject[] archives) {
        boolean isMatch = false;
        for (DynamicObject archive : archives) {
            if (!archive.getString("dimensionvalue").equals(dimensionValue.getValue()) || schemeId != archive.getDynamicObject("scheme").getLong("id") || !"normal".equals(archive.getString("archivetype"))) continue;
            isMatch = true;
        }
        return isMatch;
    }
}

