/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.archives;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.archives.DefaultArchiveLoader;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.overdue.RuleBasedOverdueCalculator;
import kd.scmc.ccm.business.scheme.CreditScheme;

public class OverdueArchiveLoader
extends DefaultArchiveLoader {
    @Override
    public ArchiveCollection loadArchives(CreditScheme scheme) {
        ArchiveCollection archives = super.loadArchives(scheme);
        this.calculateRuntimeDueday(scheme, archives);
        return archives;
    }

    @Override
    public ArchiveCollection loadArchives(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        ArchiveCollection archives = super.loadArchives(scheme, dimensionValues);
        this.calculateRuntimeDueday(scheme, archives);
        return archives;
    }

    private void calculateRuntimeDueday(CreditScheme scheme, ArchiveCollection archives) {
        RuleBasedOverdueCalculator overdueDayCalculator = new RuleBasedOverdueCalculator();
        Map<DimensionValue, BigDecimal> result = overdueDayCalculator.calculate(scheme, archives.keySet());
        for (Map.Entry<DimensionValue, BigDecimal> entry : result.entrySet()) {
            DimensionValue dimensionValue = entry.getKey();
            CreditArchive archive = (CreditArchive)archives.get(dimensionValue);
            if (archive == null) continue;
            archive.reduceBalance(entry.getValue());
        }
    }
}

