/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.archives;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.ArchiveEffectService;
import kd.scmc.ccm.business.archives.DefaultArchiveLoader;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.common.util.DateUtils;
import kd.scmc.ccm.common.util.OrmFacade;
import org.apache.commons.lang.ArrayUtils;

public class RecalculateArchiveLoader
extends DefaultArchiveLoader {
    private OrmFacade ormFacade = new OrmFacade();
    private ArchiveEffectService archiveEffectService = new ArchiveEffectService();

    @Override
    public ArchiveCollection loadArchives(CreditScheme scheme) {
        QFilter filter = new QFilter("scheme", "=", (Object)scheme.getId());
        filter.and(new QFilter("begindate", "<=", (Object)new Date()));
        filter.and(new QFilter("enddate", ">=", (Object)new Date()));
        filter.and(new QFilter("archivetype", "=", (Object)"normal"));
        DynamicObject[] rawArchives = this.ormFacade.load("ccm_archive", "billno,scheme,dimension,dimensionvalue,unit,quota,archivetype,quotatype,balance,enddate,increasesum,reducesum,effectstate,relatedid", new QFilter[]{filter});
        this.archiveEffectService.effect(rawArchives);
        return this.transDynamnicToArchive(scheme, rawArchives);
    }

    @Override
    public ArchiveCollection loadArchives(CreditScheme scheme, List<DimensionValue> dimensionValues) {
        HashSet<String> plainValues = new HashSet<String>(dimensionValues.size());
        for (DimensionValue value : dimensionValues) {
            plainValues.add(value.getValue());
        }
        QFilter dimensionValueFilter = new QFilter("dimensionvalue", "in", plainValues);
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)scheme.getId());
        Date today = new Date();
        QFilter dataRangeFilter = new QFilter("begindate", "<=", (Object)DateUtils.getEndOfDay((Date)today)).and("enddate", ">=", (Object)DateUtils.getStartOfDay((Date)today));
        QFilter typeFilter = new QFilter("archivetype", "=", (Object)"normal");
        QFilter[] filters = new QFilter[]{schemeFilter, dimensionValueFilter, dataRangeFilter, typeFilter};
        Object[] rawArchives = this.ormFacade.load("ccm_archive", "billno,scheme,dimension,dimensionvalue,unit,quota,archivetype,quotatype,balance,enddate,increasesum,reducesum,effectstate,relatedid", filters);
        Object[] autoCreatedArchives = this.getAutoCreatedArchive(scheme, dimensionValues, (DynamicObject[])rawArchives);
        Object[] transArchives = autoCreatedArchives == null ? rawArchives : (DynamicObject[])ArrayUtils.addAll((Object[])rawArchives, (Object[])autoCreatedArchives);
        this.archiveEffectService.effect((DynamicObject[])transArchives);
        return this.transDynamnicToArchive(scheme, (DynamicObject[])transArchives);
    }
}

