/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.balance;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.balance.QueryBalanceResult;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.service.CreditServiceFacade;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.business.valuegetter.DimensionValueGetter;
import kd.scmc.ccm.common.util.OrmFacade;

public class CreditBalanceQuerier {
    private static final Log logger = LogFactory.getLog(CreditBalanceQuerier.class);
    private OrmFacade ormFacade = new OrmFacade();
    private CreditServiceFacade facade;

    public CreditBalanceQuerier() {
        this.facade = new CreditServiceFacade();
    }

    public CreditBalanceQuerier(CreditServiceFacade facade) {
        this.facade = facade;
    }

    public List<QueryBalanceResult> queryBalance(CreditScheme scheme, DynamicObject bill) {
        String entityKey = bill.getDataEntityType().getName();
        List<Role> roles = scheme.getDimension().getRoles();
        BillStrategy billStrategy = scheme.getBillStrategy(entityKey);
        EntityConfig entityConfig = billStrategy.getConfig();
        String entryKey = this.getEntryKey(roles, entityConfig);
        CreditContext context = CreditContext.get();
        DimensionValueGetter dimensionValueGetter = new DimensionValueGetter(scheme, context);
        HashSet<DimensionValue> dimensionValues = new HashSet<DimensionValue>(10);
        if (entryKey == null) {
            DimensionValue dimensionValue = (DimensionValue)dimensionValueGetter.get(bill);
            dimensionValues.add(dimensionValue);
        } else {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject row : entry) {
                DimensionValue dimensionValue = (DimensionValue)dimensionValueGetter.get(row);
                dimensionValues.add(dimensionValue);
            }
        }
        return this.queryBalance(scheme, dimensionValues);
    }

    public List<QueryBalanceResult> queryBalance(CreditScheme scheme, Set<DimensionValue> dimensionValues) {
        LinkedList<QueryBalanceResult> results = new LinkedList<QueryBalanceResult>();
        String schemeName = scheme.getRawScheme().getString("name");
        ArchiveCollection archives = this.facade.loadArchives(scheme, new LinkedList<DimensionValue>(dimensionValues));
        for (DimensionValue dimensionValue : dimensionValues) {
            QueryBalanceResult queryBalanceResult = new QueryBalanceResult();
            queryBalanceResult.setScheme(schemeName);
            queryBalanceResult.setDimensionValue(this.getDimensionValueDisplayName(dimensionValue));
            CreditArchive archive = (CreditArchive)archives.get(dimensionValue);
            if (archive == null) {
                queryBalanceResult.setMessage(ResManager.loadKDString((String)"\u4fe1\u7528\u6863\u6848\u672a\u751f\u6548\u3002", (String)"CreditBalanceQuerier_0", (String)"scmc-ccm-business", (Object[])new Object[0]));
            } else {
                queryBalanceResult.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u6210\u529f\u3002", (String)"CreditBalanceQuerier_1", (String)"scmc-ccm-business", (Object[])new Object[0]));
                queryBalanceResult.setUnit(archive.getUnit());
                queryBalanceResult.setBalance(archive.getBalance());
            }
            results.add(queryBalanceResult);
        }
        return results;
    }

    private String getDimensionValueDisplayName(DimensionValue dimensionValue) {
        StringBuilder displayNameBuilder = new StringBuilder();
        List<Role> roles = dimensionValue.getDimension().getRoles();
        DimensionEntryFieldMapper dimensionEntryFieldMapper = new DimensionEntryFieldMapper(dimensionValue.getDimension().getId());
        for (int i = 0; i < roles.size(); ++i) {
            DynamicObject roleObj;
            Role role = roles.get(i);
            Object roleValue = dimensionValue.getValue(role);
            if ("CUSUNICODE".equals(role.getRoleType()) && ObjectUtils.isEmpty((Object)roleValue)) break;
            if (roleValue instanceof DynamicObject) {
                roleObj = (DynamicObject)roleValue;
            } else {
                String basedataKey = dimensionEntryFieldMapper.getBaseDataKey(role.getRoleType());
                if (roleValue instanceof Long) {
                    roleObj = this.ormFacade.loadSingleFromCache((Object)((Long)roleValue), basedataKey);
                } else if (roleValue instanceof String) {
                    roleObj = this.ormFacade.loadSingleFromCache((Object)Long.parseLong((String)roleValue), basedataKey);
                } else {
                    logger.info("roleValue is not of Long or String : {}", roleValue);
                    logger.info("It is not supported roleValueType and we will set current roleOjb is null.");
                    roleObj = null;
                }
            }
            displayNameBuilder.append(role.getRoleName()).append(':');
            displayNameBuilder.append(roleObj == null || ObjectUtils.isEmpty((Object)roleObj) ? "null" : roleObj.getString("name"));
            if (i >= roles.size() - 1) continue;
            displayNameBuilder.append('\n');
        }
        return displayNameBuilder.toString();
    }

    private String getEntryKey(List<Role> roles, EntityConfig entityConfig) {
        for (Role role : roles) {
            Field field = entityConfig.getField(role.getElement());
            if (field.getEntryKey() == null) continue;
            return field.getEntryKey();
        }
        return null;
    }
}

