/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.check;

import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.check.CreditChecker;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.scheme.CreditScheme;

public class AmountCreditChecker
implements CreditChecker {
    @Override
    public CheckResult check(JournalGroup journalGroup, ArchiveCollection archives) {
        CreditScheme scheme = journalGroup.getScheme();
        String entityKey = journalGroup.getMainEntityKey();
        CheckResult result = new CheckResult(scheme, entityKey);
        result.setSuccess(true);
        for (Journal journal : journalGroup.getJournals()) {
            CreditArchive archive = (CreditArchive)archives.get(journal.getDimensionValue());
            if (archive == null) continue;
            if (journal.getAmount().compareTo(archive.getBalance()) > 0) {
                result.setBillno(journal.getBillNo());
                result.setSuccess(false);
                long currencyId = scheme.getCurrency();
                DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
                int precision = currency.getInt("amtprecision");
                String sign = currency.getString("sign");
                String messageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u5728\u4fe1\u63a7\u65b9\u6848\u201c%1$s\u201d\u4e2d\u5bf9\u5e94\u7684\u4fe1\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u5141\u8bb8\u989d\u5ea6\u4e3a%2$s%3$s,\u672c\u6b21\u5360\u7528\u989d\u5ea6\u4e3a%4$s%5$s\u3002", (String)"AmountCreditChecker_0", (String)"scmc-ccm-business", (Object[])new Object[0]);
                String schemeName = scheme.getRawScheme().getString("name");
                String displayQuota = archive.getBalance().setScale(precision, RoundingMode.HALF_UP).toPlainString();
                String displayAmount = journal.getAmount().setScale(precision, RoundingMode.HALF_UP).toPlainString();
                String message = String.format(messageTemplate, schemeName, sign, displayQuota, sign, displayAmount);
                result.setMessage(message);
                return result;
            }
            archive.reduceBalance(journal.getAmount());
        }
        return result;
    }
}

