/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.check;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.check.CreditChecker;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.scheme.CreditScheme;

public class OverdueAmountChecker
implements CreditChecker {
    @Override
    public CheckResult check(JournalGroup journalGroup, ArchiveCollection archives) {
        CreditScheme scheme = journalGroup.getScheme();
        String entityKey = journalGroup.getMainEntityKey();
        CheckResult result = new CheckResult(scheme, entityKey);
        result.setSuccess(true);
        for (Journal journal : journalGroup.getJournals()) {
            CreditArchive archive = (CreditArchive)archives.get(journal.getDimensionValue());
            if (archive == null) continue;
            BigDecimal maxOverdueAmount = archive.getQuota().setScale(archive.getCurrencyPrecision(), 4);
            BigDecimal currentOverdueAmount = archive.getBalance().setScale(archive.getCurrencyPrecision(), 4);
            result.setBillno(journal.getBillNo());
            if (currentOverdueAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
            result.setSuccess(false);
            String schemeName = scheme.getRawScheme().getString("name");
            String messageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u5728\u4fe1\u63a7\u65b9\u6848\u201c%1$s\u201d\u4e2d\uff0c\u5141\u8bb8\u903e\u671f\u989d\u5ea6\u4e3a%2$s%3$s\uff0c\u5b9e\u9645\u903e\u671f\u989d\u5ea6\u4e3a%4$s%5$s\uff0c\u5f53\u524d\u8d85\u989d\u4e3a%6$s%7$s\u3002", (String)"OverdueAmountChecker_0", (String)"scmc-ccm-business", (Object[])new Object[0]);
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getCurrency(), (String)"bd_currency");
            int precision = currency.getInt("amtprecision");
            String sign = currency.getString("sign");
            String quota = maxOverdueAmount.setScale(precision, RoundingMode.HALF_UP).toPlainString();
            String actualOverdueAmount = maxOverdueAmount.subtract(currentOverdueAmount).setScale(precision, RoundingMode.HALF_UP).toPlainString();
            String overdueAmount = currentOverdueAmount.negate().setScale(precision, RoundingMode.HALF_UP).toPlainString();
            String message = String.format(messageTemplate, schemeName, sign, quota, sign, actualOverdueAmount, sign, overdueAmount);
            result.setMessage(message);
            return result;
        }
        return result;
    }
}

