/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.check;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.archives.CreditArchive;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.check.CreditChecker;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.scheme.BillStrategy;
import kd.scmc.ccm.business.scheme.CreditScheme;

public class QuotaCreditChecker
implements CreditChecker {
    private static final Log logger = LogFactory.getLog(QuotaCreditChecker.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern(TimeServiceHelper.getDateTimeFormatString());

    @Override
    public CheckResult check(JournalGroup journalGroup, ArchiveCollection archives) {
        CreditScheme scheme = journalGroup.getScheme();
        String quotaType = scheme.getQuotaType().getQuotaType();
        String entityKey = journalGroup.getMainEntityKey();
        CheckResult result = new CheckResult(scheme, entityKey);
        result.setSuccess(true);
        result.setBillno(journalGroup.getBillNo());
        Map<Object, Object> privilegeAmtMap = new HashMap();
        if ("amount".equals(quotaType)) {
            privilegeAmtMap = this.calPrivilegeAmt(journalGroup);
        }
        CreditContext txt = CreditContext.get();
        String opKey = txt.getOperateKey();
        BillStrategy bs = scheme.getBillStrategy(txt.getEntityKey());
        List<String> reversOps = bs.getReverseOps();
        boolean isReverse = false;
        if (reversOps != null && reversOps.contains(opKey) || "unsubmit".equals(opKey) || "unaudit".equals(opKey) || "bizunclose".equals(opKey) || "bizuncancel".equals(opKey)) {
            isReverse = true;
        }
        for (Journal journal : journalGroup.getJournals()) {
            BigDecimal privilegeAmt;
            CreditArchive archive = (CreditArchive)archives.get(journal.getDimensionValue());
            if (archive == null) continue;
            String direction = journal.getDirection();
            result.setDirection(direction);
            BigDecimal balance = archive.getBalance();
            if (!privilegeAmtMap.isEmpty() && (privilegeAmt = (BigDecimal)privilegeAmtMap.get(journal.getBillId())) != null) {
                balance = balance.add(privilegeAmt).setScale(archive.getCurrencyPrecision());
            }
            BigDecimal amount = "REDUCE".equals(direction) ? journal.getAmount() : journal.getAmount().negate();
            String directionMessage = this.getDirectionStr(direction);
            if ("privilegeamt".equals(quotaType) || "qty".equals(quotaType)) {
                if (amount.compareTo(balance) > 0) {
                    int precision;
                    result.setSuccess(false);
                    String schemeName = scheme.getRawScheme().getString("name");
                    if ("privilegeamt".equals(quotaType)) {
                        long currencyId = scheme.getCurrency();
                        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"id,amtprecision,sign");
                        precision = currency.getInt("amtprecision");
                        String sign = currency.getString("sign");
                        BigDecimal displayQuota = balance.setScale(precision, RoundingMode.HALF_UP);
                        BigDecimal displayAmount = journal.getAmount().setScale(precision, RoundingMode.HALF_UP);
                        BigDecimal receivableAmt = amount.subtract(balance).setScale(precision, RoundingMode.HALF_UP);
                        String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5728\u4fe1\u63a7\u65b9\u6848\u201c%1$s\u201d\u4e2d\u5bf9\u5e94\u7684\u4fe1\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u53ef\u7528\u989d\u5ea6\u4e3a%2$s%3$s\uff0c\u672c\u6b21%4$s\u989d\u5ea6\u4e3a%5$s%6$s\uff0c\u9700\u56de\u6b3e\u989d\u5ea6\u4e3a%7$s%8$s\u3002", (String)"QuotaCreditChecker_0", (String)"scmc-ccm-business", (Object[])new Object[0]), schemeName, sign, displayQuota, directionMessage, sign, displayAmount, sign, receivableAmt);
                        result.setBalance(balance);
                        result.setAmount(journal.getAmount());
                        result.setUnit(currencyId);
                        result.setMessage(message);
                    }
                    if ("qty".equals(quotaType)) {
                        long unit = archive.getUnit();
                        DynamicObject measureUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)unit, (String)"bd_measureunits");
                        precision = 10;
                        if (measureUnit != null) {
                            precision = measureUnit.getInt("precision");
                        }
                        BigDecimal displayQuota = archive.getBalance().setScale(precision, RoundingMode.HALF_UP);
                        BigDecimal displayAmount = journal.getAmount().setScale(precision, RoundingMode.HALF_UP);
                        String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5728\u4fe1\u63a7\u65b9\u6848\u201c%1$s\u201d\u4e2d\u5bf9\u5e94\u7684\u4fe1\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u53ef\u7528\u6570\u91cf\u4e3a%2$s\uff0c\u672c\u6b21%3$s\u6570\u91cf\u4e3a%4$s\u3002", (String)"QuotaCreditChecker_1", (String)"scmc-ccm-business", (Object[])new Object[0]), schemeName, displayQuota, directionMessage, displayAmount);
                        result.setBalance(archive.getBalance());
                        result.setAmount(journal.getAmount());
                        result.setUnit(unit);
                        result.setMessage(message);
                    }
                    return result;
                }
                if ("REDUCE".equals(direction)) {
                    archive.reduceBalance(journal.getAmount());
                }
                if ("INCREASE".equals(direction)) {
                    archive.increaseBalance(journal.getAmount());
                }
            }
            if (!"amount".equals(quotaType)) continue;
            BigDecimal journalAmount = journal.getAmount();
            logger.info("\u4fe1\u63a7\u7c7b\u578b\u4e3a\u989d\u5ea6\uff0c\u68c0\u67e5\u65f6\u95f4\uff1a{},\u4fe1\u63a7\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c\u4fe1\u63a7\u5206\u5f55ID\uff1a{}\uff0c\u4fe1\u63a7\u65b9\u5411\uff1a{}\uff0c\u662f\u5426\u53cd\u5411\uff1a{}\uff0c\u6d41\u6c34\u91d1\u989d\uff1a{}", new Object[]{formatter.format(LocalDateTime.now()), journal.getBillNo(), journal.getEntryId(), direction, isReverse, journalAmount});
            BigDecimal newBalance = BigDecimal.ZERO;
            if (!isReverse && "REDUCE".equals(direction) || isReverse && "INCREASE".equals(direction)) {
                newBalance = balance.subtract(journalAmount).setScale(archive.getCurrencyPrecision(), 4);
                if (newBalance.compareTo(BigDecimal.ZERO) >= 0 || newBalance.compareTo(balance) >= 0) {
                    archive.reduceBalance(journalAmount);
                    continue;
                }
                this.setCheckResult(result, scheme, "REDUCE", balance, journalAmount, newBalance);
                return result;
            }
            if ((!"REDUCE".equals(direction) || !isReverse) && !"INCREASE".equals(direction)) continue;
            newBalance = balance.add(journalAmount).setScale(archive.getCurrencyPrecision(), 4);
            if (newBalance.compareTo(BigDecimal.ZERO) >= 0 || newBalance.compareTo(balance) >= 0) {
                archive.increaseBalance(journalAmount);
                continue;
            }
            this.setCheckResult(result, scheme, "INCREASE", balance, journalAmount, newBalance);
            return result;
        }
        return result;
    }

    private void setCheckResult(CheckResult result, CreditScheme scheme, String msgDirection, BigDecimal balance, BigDecimal journalAmount, BigDecimal newBalance) {
        result.setSuccess(false);
        String schemeName = scheme.getRawScheme().getString("name");
        long currencyId = scheme.getCurrency();
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"id,amtprecision,sign");
        int precision = currency.getInt("amtprecision");
        String sign = currency.getString("sign");
        BigDecimal displayQuota = balance.setScale(precision, RoundingMode.HALF_UP);
        BigDecimal displayAmount = journalAmount.setScale(precision, RoundingMode.HALF_UP);
        BigDecimal receivableAmt = newBalance.abs().setScale(precision, RoundingMode.HALF_UP);
        String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5728\u4fe1\u63a7\u65b9\u6848\u201c%1$s\u201d\u4e2d\u5bf9\u5e94\u7684\u4fe1\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u53ef\u7528\u989d\u5ea6\u4e3a%2$s%3$s\uff0c\u672c\u6b21%4$s\u989d\u5ea6\u4e3a%5$s%6$s\uff0c\u9700\u56de\u6b3e\u989d\u5ea6\u4e3a%7$s%8$s\u3002", (String)"QuotaCreditChecker_0", (String)"scmc-ccm-business", (Object[])new Object[0]), schemeName, sign, displayQuota, this.getDirectionStr(msgDirection), sign, displayAmount, sign, receivableAmt);
        result.setBalance(balance);
        result.setAmount(journalAmount);
        result.setUnit(currencyId);
        result.setMessage(message);
    }

    private String getDirectionStr(String direction) {
        return "REDUCE".equals(direction) ? ResManager.loadKDString((String)"\u5360\u7528", (String)"QuotaCreditChecker_2", (String)"scmc-ccm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8fd4\u8fd8", (String)"QuotaCreditChecker_3", (String)"scmc-ccm-business", (Object[])new Object[0]);
    }

    private Map<Long, BigDecimal> calPrivilegeAmt(JournalGroup journalGroup) {
        HashMap<Long, BigDecimal> privilegeAmtMap = new HashMap<Long, BigDecimal>();
        Set billIdSet = journalGroup.getJournals().stream().map(Journal::getBillId).collect(Collectors.toSet());
        Set entityKeySet = journalGroup.getJournals().stream().map(Journal::getEntityKey).collect(Collectors.toSet());
        QFilter billIdFilter = new QFilter("billid", "in", billIdSet);
        QFilter entityKeyFilter = new QFilter("entitykey", "in", entityKeySet);
        QFilter quotaTypeFilter = new QFilter("quotatype", "=", (Object)"privilegeamt");
        DynamicObjectCollection privilegeJournalInfo = QueryServiceHelper.query((String)"ccm_journal", (String)"billid,amount", (QFilter[])new QFilter[]{billIdFilter, entityKeyFilter, quotaTypeFilter});
        for (DynamicObject privilegeJournal : privilegeJournalInfo) {
            long billId = privilegeJournal.getLong("billid");
            BigDecimal amount = privilegeJournal.getBigDecimal("amount");
            BigDecimal amountSum = (BigDecimal)privilegeAmtMap.get(billId);
            if (amountSum != null) {
                amount = amountSum.add(amount);
            }
            privilegeAmtMap.put(billId, amount);
        }
        return privilegeAmtMap;
    }
}

