/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.formula.FormulaEngine;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.core.CreditFormula;
import kd.scmc.ccm.business.core.Field;

public class CreditCondition {
    private List<Field> fields = new LinkedList<Field>();
    private CRCondition condition;

    public CreditCondition(String entityKey, CRCondition condition) {
        if (condition != null) {
            this.condition = condition;
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
            List<String> conditionFields = this.getConditionFields(entityKey);
            for (String key : conditionFields) {
                this.fields.add(new Field(key, dataEntityType));
            }
            String expression = condition.getExpression();
            CreditFormula creditFormula = new CreditFormula(entityKey, expression);
            this.fields.addAll(creditFormula.getFields());
        }
    }

    private List<String> getConditionFields(String entityKey) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        String fullFormula = this.condition.buildFullFormula(dataEntityType);
        String[] extractVariables = FormulaEngine.extractVariables((String)fullFormula);
        return new ArrayList<String>(Arrays.asList(extractVariables));
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public CRCondition getCondition() {
        return this.condition;
    }

    public void setCondition(CRCondition condition) {
        this.condition = condition;
    }
}

