/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.core;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ccm.business.core.Field;

public class CreditFormula {
    private String expression;
    private List<Field> fields = new LinkedList<Field>();

    public CreditFormula(String entityKey, String expression) {
        if (expression != null) {
            this.expression = expression;
            this.expression = this.expression.replace(" and ", " && ").replace(" or ", " || ");
            List<String> formulaKeys = this.getFormulaKeys();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
            for (String formulaKey : formulaKeys) {
                Field field = new Field(formulaKey, dataEntityType);
                this.fields.add(field);
            }
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    private List<String> getFormulaKeys() {
        String str;
        ArrayList<String> keys = new ArrayList<String>();
        StringBuilder tem = new StringBuilder();
        char[] charArray = this.expression.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (this.isOperator(charArray[i])) {
                String str2 = tem.toString();
                if (!(str2.length() <= 0 || this.isNumber(str2.charAt(0)) || this.isLogic(str2) || this.isStringConst(str2))) {
                    keys.add(str2);
                }
                tem = new StringBuilder();
                continue;
            }
            tem.append(charArray[i]);
        }
        if (!(tem.length() <= 0 || (str = tem.toString()).length() <= 0 || this.isNumber(str.charAt(0)) || this.isLogic(str) || this.isStringConst(str))) {
            keys.add(str);
        }
        return keys;
    }

    private boolean isOperator(char c) {
        return '+' == c || '-' == c || '*' == c || '/' == c || '(' == c || ')' == c || '=' == c || '>' == c || '<' == c || ' ' == c || '&' == c || '|' == c;
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isLogic(String str) {
        return "and".equals(str) || "or".equals(str);
    }

    private boolean isStringConst(String str) {
        return '\'' == str.charAt(0) && '\'' == str.charAt(str.length() - 1);
    }

    public String toString() {
        return this.expression;
    }
}

