/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.Role;

public class DimensionValue {
    private Dimension dimension;
    private String value;
    private Map<Role, Object> valueMap = new HashMap<Role, Object>();

    public DimensionValue(Dimension dimension) {
        this.dimension = dimension;
    }

    public String getValue() {
        return this.value;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Map<Role, Object> getValueMap() {
        return this.valueMap;
    }

    public void putValue(Role role, Object roleValue) {
        this.valueMap.put(role, roleValue);
        ArrayList<String> values = new ArrayList<String>();
        for (Role creditRole : this.dimension.getRoles()) {
            Object object = this.valueMap.get(creditRole);
            if (object == null) continue;
            values.add(object.toString());
        }
        this.value = String.join((CharSequence)"-", values);
    }

    public Object getValue(Role role) {
        return this.valueMap.get(role);
    }

    public void setValues(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Role creditRole = this.dimension.getRoles().get(i);
            this.putValue(creditRole, values[i]);
        }
    }

    public void setValue(String value) {
        this.setValues(value.split("-"));
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dimension == null ? 0 : this.dimension.hashCode());
        hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DimensionValue) {
            DimensionValue dimensionValue = (DimensionValue)obj;
            return Objects.equals(this.value, dimensionValue.value) && Objects.equals(this.dimension, dimensionValue.dimension);
        }
        return false;
    }

    public String toString() {
        return "{value=" + this.value + '}';
    }
}

