/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class Quota {
    public static final String TYPE_AMOUNT = "amount";
    public static final String TYPE_QTY = "qty";
    public static final String TYPE_DAY = "days";
    public static final String TYPE_TIMES = "times";
    public static final String TYPE_OVERDUEAMT = "overdueamt";
    public static final String TYPE_PRIVILEGEAMT = "privilegeamt";
    public static final String TYPE_PRIVILEGEDAY = "privilegeday";
    private String quotaType;
    private long unit;
    private BigDecimal quota;
    private BigDecimal oldBalance;
    private BigDecimal balance;
    private List<DynamicObject> rawArchives = new ArrayList<DynamicObject>();

    public String getQuotaType() {
        return this.quotaType;
    }

    public void setQuotaType(String quotaType) {
        this.quotaType = quotaType;
    }

    public void reduce(BigDecimal reduceValue) {
        this.balance = this.balance.subtract(reduceValue);
    }

    public void increase(BigDecimal increaseValue) {
        this.balance = this.balance.add(increaseValue);
    }

    public void increaseQuota(BigDecimal increaseValue) {
        this.quota = this.quota.add(increaseValue);
    }

    public List<DynamicObject> getRawArchives() {
        return this.rawArchives;
    }

    public void setRawArchives(List<DynamicObject> rawArchives) {
        this.rawArchives = rawArchives;
    }

    public BigDecimal getQuota() {
        return this.quota;
    }

    public void setQuota(BigDecimal quota) {
        this.quota = quota;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getOldBalance() {
        return this.oldBalance;
    }

    public void setOldBalance(BigDecimal oldBalance) {
        this.oldBalance = oldBalance;
    }

    public long getUnit() {
        return this.unit;
    }

    public void setUnit(long unit) {
        this.unit = unit;
    }

    public DynamicObject getMainArchive() {
        for (DynamicObject rawArchive : this.rawArchives) {
            if (!Objects.equals("normal", rawArchive.getString("archivetype"))) continue;
            return rawArchive;
        }
        String messageTemplate = ResManager.loadKDString((String)"\u4fe1\u7528\u7ba1\u7406\u7684\u4fe1\u63a7\u65b9\u6848\u201c%s\u201d\u627e\u4e0d\u5230\u4e3b\u6863\u6848\u3002", (String)"Quota_0", (String)"scmc-ccm-business", (Object[])new Object[0]);
        throw new KDBizException(String.format(messageTemplate, this.rawArchives.get(0).getLocaleString("scheme.name")));
    }
}

