/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.filter;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.scmc.ccm.business.core.CreditCondition;
import kd.scmc.ccm.business.core.CreditFormula;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.filter.BillFilter;
import kd.scmc.ccm.business.filter.FilterExpressionParser;
import kd.scmc.ccm.common.util.MetadataUtils;

public class BillConditionFilter
implements BillFilter {
    private CRCondition condition;

    public BillConditionFilter(CreditCondition condition) {
        if (condition != null) {
            this.condition = condition.getCondition();
        }
    }

    @Override
    public boolean isBillMatch(DynamicObject bill) {
        if (this.condition == null) {
            return true;
        }
        String entrykey = this.getEntryKey(bill);
        if (entrykey != null) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entrykey);
            for (DynamicObject row : entry) {
                if (!this.isRowMatch(row)) continue;
                return true;
            }
            return false;
        }
        return this.isMatch(bill, null);
    }

    @Override
    public boolean isRowMatch(DynamicObject row) {
        if (this.condition == null) {
            return true;
        }
        return this.isMatch((DynamicObject)row.getParent(), row);
    }

    private boolean isMatch(DynamicObject bill, DynamicObject rowObj) {
        boolean isMatch = FilterExpressionParser.isMatch(this.condition, bill, rowObj);
        return isMatch;
    }

    private String getEntryKey(DynamicObject bill) {
        List filterRows = this.condition.getFilterCondition().getFilterRow();
        String entrykey = null;
        for (int i = 0; i < filterRows.size(); ++i) {
            SimpleFilterRow row = (SimpleFilterRow)filterRows.get(i);
            String fieldName = row.getFieldName();
            entrykey = MetadataUtils.getEntryKey((MainEntityType)((MainEntityType)bill.getDataEntityType()), (String)fieldName);
            if (entrykey == null) continue;
            return entrykey;
        }
        String expression = this.condition.getExpression();
        CreditFormula creditFormula = new CreditFormula(bill.getDataEntityType().getName(), expression);
        List<Field> fields = creditFormula.getFields();
        for (Field field : fields) {
            entrykey = field.getEntryKey();
            if (entrykey == null) continue;
            return entrykey;
        }
        return entrykey;
    }
}

