/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.filter;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.filter.BillFilter;
import kd.scmc.ccm.business.monitor.Monitor;
import kd.scmc.ccm.business.scheme.CreditScheme;

public class CreditCurrencyBillFilter
implements BillFilter {
    private Field currencyField;
    private CreditScheme scheme;

    public CreditCurrencyBillFilter(CreditScheme scheme, Field currencyField) {
        this.currencyField = currencyField;
        this.scheme = scheme;
    }

    @Override
    public boolean isBillMatch(DynamicObject bill) {
        if (this.currencyField.getEntryKey() != null) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(this.currencyField.getEntryKey());
            for (DynamicObject row : entry) {
                if (!this.isRowMatch(row)) continue;
                return true;
            }
            return false;
        }
        Object currency = bill.get(this.currencyField.getKey());
        return this.isCurrencyMatch(currency, this.scheme);
    }

    @Override
    public boolean isRowMatch(DynamicObject row) {
        if (!Objects.equals(this.scheme.getQuotaType().getQuotaType(), "amount")) {
            Monitor.getDebugDetail(this.scheme).info(this.getClass(), "SchemeQuotaType:", this.scheme.getQuotaType().getQuotaType());
            return true;
        }
        if (this.currencyField.getEntryKey() != null) {
            Object currency = row.get(this.currencyField.getKey());
            return this.isCurrencyMatch(currency, this.scheme);
        }
        return this.isBillMatch((DynamicObject)row.getParent());
    }

    private boolean isCurrencyMatch(Object currency, CreditScheme scheme) {
        Object currencyPk;
        if (currency == null) {
            Monitor.getDebugDetail(scheme).info(this.getClass(), "currency is NULL");
            return false;
        }
        if (!(currency instanceof DynamicObject) && !(currency instanceof Long)) {
            throw new KDBizException("unsupport currency match datatype error:field=" + this.currencyField.getKey());
        }
        Object object = currencyPk = currency instanceof DynamicObject ? ((DynamicObject)currency).getPkValue() : currency;
        if (scheme.isSingleCurrencyControl()) {
            Monitor.getDebugDetail(scheme).info(this.getClass(), "bill currency=", currencyPk);
            return Objects.equals(currencyPk, scheme.getCurrency());
        }
        return true;
    }
}

