/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.filter;

import java.util.Stack;

public class ExpressionCalculator {
    public static boolean calculate(String expression) {
        StringBuilder profixExpr = new StringBuilder();
        Stack<Character> optr = new Stack<Character>();
        for (int i = 0; i < expression.length(); ++i) {
            char pop;
            char c = expression.charAt(i);
            if (ExpressionCalculator.isOperand(c)) {
                profixExpr.append(c);
                continue;
            }
            if (ExpressionCalculator.isOptr(c)) {
                if (optr.isEmpty()) {
                    optr.push(Character.valueOf(c));
                    continue;
                }
                while (!optr.isEmpty() && ExpressionCalculator.priority(((Character)optr.peek()).charValue()) >= ExpressionCalculator.priority(c)) {
                    pop = ((Character)optr.pop()).charValue();
                    profixExpr.append(pop);
                }
                optr.push(Character.valueOf(c));
                continue;
            }
            if ('(' == c) {
                optr.push(Character.valueOf(c));
                continue;
            }
            if (')' == c) {
                while ((pop = ((Character)optr.pop()).charValue()) != '(') {
                    profixExpr.append(pop);
                }
                continue;
            }
            throw new IllegalArgumentException("Expression error:" + c);
        }
        while (!optr.isEmpty()) {
            profixExpr.append(optr.pop());
        }
        return ExpressionCalculator.booleanCalculate(profixExpr.toString());
    }

    private static boolean booleanCalculate(String profixExpr) {
        Stack<Boolean> count = new Stack<Boolean>();
        block4: for (int i = 0; i < profixExpr.length(); ++i) {
            char c = profixExpr.charAt(i);
            if ('1' == c) {
                count.push(Boolean.TRUE);
                continue;
            }
            if ('0' == c) {
                count.push(Boolean.FALSE);
                continue;
            }
            boolean number2 = (Boolean)count.pop();
            boolean number1 = (Boolean)count.pop();
            switch (c) {
                case '&': {
                    count.push(number1 & number2);
                    continue block4;
                }
                case '|': {
                    count.push(number1 | number2);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("");
                }
            }
        }
        return (Boolean)count.pop();
    }

    private static boolean isOptr(char c) {
        return c == '&' || c == '|';
    }

    private static boolean isOperand(char c) {
        return '0' == c || '1' == c;
    }

    private static int priority(char c) {
        switch (c) {
            case '&': {
                return 3;
            }
            case '|': {
                return 2;
            }
            case '(': {
                return 1;
            }
        }
        return 0;
    }
}

