/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.scmc.ccm.common.util.MetadataUtils;

public class FilterExpressionParser {
    private static final Log logger = LogFactory.getLog(FilterExpressionParser.class);

    public static boolean isMatch(Object fieldValue, SimpleFilterRow filterRow) {
        if (fieldValue instanceof ILocaleString) {
            fieldValue = ((ILocaleString)fieldValue).getLocaleValue();
        } else if (fieldValue instanceof Boolean) {
            fieldValue = fieldValue != null && (Boolean)fieldValue != false ? "1" : "0";
        }
        List validValues = filterRow.getValue();
        String compareType = filterRow.getCompareType();
        if (CompareTypeEnum.EQUAL.getId().equals(compareType) || CompareTypeEnum.CHECKBOXEQUAL.getId().equals(compareType)) {
            FilterValue amiValue = (FilterValue)validValues.get(0);
            return Objects.equals(fieldValue, amiValue.getValue());
        }
        if (CompareTypeEnum.NOTEQUAL.getId().equals(compareType) || CompareTypeEnum.CHECKBOXNOTEQUAL.getId().equals(compareType)) {
            FilterValue amiValue = (FilterValue)validValues.get(0);
            return !Objects.equals(fieldValue, amiValue.getValue());
        }
        if (CompareTypeEnum.IN.getId().equals(compareType)) {
            for (FilterValue amiValue : validValues) {
                if (!Objects.equals(fieldValue, amiValue.getValue())) continue;
                return true;
            }
        } else {
            if (CompareTypeEnum.NOTIN.getId().equals(compareType)) {
                for (FilterValue amiValue : validValues) {
                    if (!Objects.equals(fieldValue, amiValue.getValue())) continue;
                    return false;
                }
                return true;
            }
            if (CompareTypeEnum.ISNOTNULL.getId().equals(compareType) || CompareTypeEnum.COMBOBOXISNOTNULL.getId().equals(compareType)) {
                return !ObjectUtils.isEmpty((Object)fieldValue);
            }
            if (CompareTypeEnum.ISNULL.getId().equals(compareType) || CompareTypeEnum.COMBOBOXISNULL.getId().equals(compareType)) {
                return ObjectUtils.isEmpty((Object)fieldValue);
            }
            if (CompareTypeEnum.GREATER.getId().equals(compareType)) {
                String valueStr = ((FilterValue)validValues.get(0)).getValue().toString();
                double amiValue = Double.parseDouble(valueStr);
                if (fieldValue instanceof Number && ((Number)fieldValue).doubleValue() > amiValue) {
                    return true;
                }
            } else if (CompareTypeEnum.LESS.getId().equals(compareType)) {
                String valueStr = ((FilterValue)validValues.get(0)).getValue().toString();
                double amiValue = Double.parseDouble(valueStr);
                if (fieldValue instanceof Number && ((Number)fieldValue).doubleValue() < amiValue) {
                    return true;
                }
            } else if (CompareTypeEnum.GREATEROREQUAL.getId().equals(compareType)) {
                String valueStr = ((FilterValue)validValues.get(0)).getValue().toString();
                double amiValue = Double.parseDouble(valueStr);
                if (fieldValue instanceof Number && ((Number)fieldValue).doubleValue() >= amiValue) {
                    return true;
                }
            } else if (CompareTypeEnum.LESSOREQUAL.getId().equals(compareType)) {
                String valueStr = ((FilterValue)validValues.get(0)).getValue().toString();
                double amiValue = Double.parseDouble(valueStr);
                if (fieldValue instanceof Number && ((Number)fieldValue).doubleValue() <= amiValue) {
                    return true;
                }
            } else {
                if (CompareTypeEnum.LIKE.getId().equals(compareType)) {
                    String valueStr = ((FilterValue)validValues.get(0)).getValue().toString();
                    return String.valueOf(fieldValue).contains(valueStr);
                }
                if (CompareTypeEnum.NOTLIKE.getId().equals(compareType)) {
                    String valueStr = ((FilterValue)validValues.get(0)).getValue().toString();
                    return !String.valueOf(fieldValue).contains(valueStr);
                }
                if (CompareTypeEnum.LEFTLIKE.getId().equals(compareType)) {
                    String valueStr = ((FilterValue)validValues.get(0)).getValue().toString();
                    return String.valueOf(fieldValue).startsWith(valueStr);
                }
                if (CompareTypeEnum.RIGHTLIKE.getId().equals(compareType)) {
                    String valueStr = ((FilterValue)validValues.get(0)).getValue().toString();
                    return String.valueOf(fieldValue).endsWith(valueStr);
                }
                throw new KDBizException("Unsupported yet.compareType=" + compareType);
            }
        }
        return false;
    }

    public static boolean isMatch(CRCondition condition, DynamicObject bill, DynamicObject row) {
        String fullFormula = condition.buildFullFormula((MainEntityType)bill.getDataEntityType());
        if (StringUtils.isEmpty((String)fullFormula)) {
            return true;
        }
        try {
            String[] vars = FormulaEngine.extractVariables((String)fullFormula);
            IDataEntityType dataEntityType = bill.getDataEntityType();
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            for (String fieldName : vars) {
                Object fieldValue;
                String entrykey = MetadataUtils.getEntryKey((MainEntityType)((MainEntityType)dataEntityType), (String)fieldName);
                Object object = fieldValue = entrykey == null ? bill.get(fieldName) : row.get(fieldName);
                if (fieldValue instanceof ILocaleString) {
                    fieldValue = ((ILocaleString)fieldValue).getLocaleValue();
                }
                params.put(fieldName, fieldValue);
            }
            boolean match = (Boolean)FormulaEngine.execExcelFormula((String)fullFormula, params);
            return match;
        }
        catch (Exception e) {
            logger.error("match parser occured exception", (Throwable)e);
            throw new KDBizException("match parser occured exception");
        }
    }
}

