/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.QuotaType;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalBuilder;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.scheme.SchemeReader;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;

public class AdjustJournalBuilder
implements JournalBuilder {
    @Override
    public List<JournalGroup> buildJournals(List<DynamicObject> bills) {
        LinkedList<JournalGroup> journalGroups = new LinkedList<JournalGroup>();
        for (DynamicObject bill : bills) {
            JournalGroup journalGroup = this.buildJournals(bill);
            journalGroups.add(journalGroup);
        }
        return journalGroups;
    }

    public JournalGroup buildJournals(DynamicObject balanceAdjustment) {
        JournalGroup journalGroup = new JournalGroup();
        SchemeReader reader = new SchemeReader();
        CreditScheme scheme = reader.getScheme(balanceAdjustment.getLong("scheme.id"));
        journalGroup.setScheme(scheme);
        journalGroup.setBillNo(balanceAdjustment.getString("billno"));
        journalGroup.setMainBillId(balanceAdjustment.getLong("id"));
        journalGroup.setMainEntityKey(balanceAdjustment.getDataEntityType().getName());
        ArrayList<Journal> journals = new ArrayList<Journal>();
        journalGroup.setJournals(journals);
        DynamicObjectCollection entry = balanceAdjustment.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            Journal journal = this.createJournal(balanceAdjustment, row, scheme);
            journals.add(journal);
        }
        return journalGroup;
    }

    private Journal createJournal(DynamicObject balanceAdjustment, DynamicObject row, CreditScheme scheme) {
        Journal journal = new Journal();
        journal.setOrg(balanceAdjustment.getDynamicObject("org").getLong("id"));
        journal.setScheme(scheme);
        Dimension dimension = scheme.getDimension();
        DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getId());
        DimensionValue dimensionValue = new DimensionValue(dimension);
        dimensionValue.setValue(this.getDimensionValueStr(row, mapper.getRoleFieldKeys()));
        journal.setDimensionValue(dimensionValue);
        journal.setMainBillId(balanceAdjustment.getLong("id"));
        journal.setMainEntityKey(balanceAdjustment.getDataEntityType().getName());
        journal.setEntityKey(balanceAdjustment.getDataEntityType().getName());
        journal.setBillNo(balanceAdjustment.getString("billno"));
        journal.setBillId(balanceAdjustment.getLong("id"));
        journal.setEntryKey(row.getDataEntityType().getName());
        journal.setEntryId(row.getLong("id"));
        journal.setAction("ADJUST");
        journal.setOp("audit");
        QuotaType quotaType = scheme.getQuotaType();
        journal.setQuotaType(quotaType.getQuotaType());
        BigDecimal amount = row.getBigDecimal("amount");
        if (this.isReduceDirection(amount)) {
            journal.setDirection("REDUCE");
            journal.setOriginalAmount(amount.abs());
            journal.setAmount(amount.abs());
        } else {
            journal.setDirection("INCREASE");
            journal.setOriginalAmount(amount);
            journal.setAmount(amount);
        }
        journal.setOriginalUnit(scheme.getCurrency());
        journal.setOriginalUnitPrecision(scheme.getCurrencyPrecision());
        journal.setUnit(scheme.getCurrency());
        journal.setUnitPrecision(scheme.getCurrencyPrecision());
        journal.setConversionRate(BigDecimal.ONE);
        return journal;
    }

    private String getDimensionValueStr(DynamicObject row, List<String> roleFieldKeys) {
        ArrayList<String> pkValues = new ArrayList<String>(roleFieldKeys.size());
        for (String roleFieldKey : roleFieldKeys) {
            DynamicObject roleFieldValue = row.getDynamicObject(roleFieldKey);
            pkValues.add(roleFieldValue.getString("masterid"));
        }
        return String.join((CharSequence)"-", pkValues);
    }

    private boolean isReduceDirection(BigDecimal amount) {
        return amount.compareTo(BigDecimal.ZERO) < 0;
    }
}

