/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.QuotaType;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalBuilder;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.scheme.CreditScheme;

public class PrivilegeJournalBuilder
implements JournalBuilder {
    private CreditScheme scheme;

    public PrivilegeJournalBuilder(CreditScheme scheme) {
        this.scheme = scheme;
    }

    @Override
    public List<JournalGroup> buildJournals(List<DynamicObject> bills) {
        LinkedList<JournalGroup> journalGroups = new LinkedList<JournalGroup>();
        for (DynamicObject bill : bills) {
            JournalGroup journalGroup = this.buildJournals(bill);
            journalGroups.add(journalGroup);
        }
        return journalGroups;
    }

    private JournalGroup buildJournals(DynamicObject bill) {
        JournalGroup journalGroup = new JournalGroup();
        journalGroup.setScheme(this.scheme);
        journalGroup.setBillNo(bill.getString("billno"));
        journalGroup.setMainBillId(bill.getLong("id"));
        journalGroup.setMainEntityKey(bill.getDataEntityType().getName());
        ArrayList<Journal> journals = new ArrayList<Journal>();
        journalGroup.setJournals(journals);
        Journal journal = this.createJournal(bill);
        journals.add(journal);
        return journalGroup;
    }

    private Journal createJournal(DynamicObject bill) {
        CreditContext creditContext = CreditContext.get();
        Journal journal = new Journal();
        journal.setOrg(bill.getDynamicObject("org").getLong("id"));
        journal.setScheme(this.scheme);
        Dimension dimension = this.scheme.getDimension();
        DimensionValue dimensionValue = new DimensionValue(dimension);
        dimensionValue.setValue(bill.getString("dimensionvalue"));
        journal.setDimensionValue(dimensionValue);
        journal.setMainBillId(bill.getLong("id"));
        journal.setMainEntityKey(creditContext.getEntityKey());
        journal.setEntityKey(bill.getDynamicObject("srcbillentity").getString("number"));
        journal.setBillNo(bill.getString("srcbillno"));
        journal.setBillId(bill.getLong("srcbillid"));
        journal.setAction(creditContext.getCreditAction());
        journal.setOp(creditContext.getOperateKey());
        QuotaType quotaType = this.scheme.getQuotaType();
        journal.setQuotaType(quotaType.getQuotaType());
        BigDecimal amount = bill.getBigDecimal("privilegedamount");
        String checktype = this.scheme.getRawScheme().getString("checktype.number");
        if ("KZFW011".equals(checktype)) {
            amount = bill.getBigDecimal("privilegedday");
        }
        if ("privilegeamt".equals(quotaType.getQuotaType())) {
            journal.setOriginalUnitPrecision(this.scheme.getCurrencyPrecision());
            journal.setUnitPrecision(this.scheme.getCurrencyPrecision());
        }
        journal.setDirection("REDUCE");
        journal.setOriginalAmount(amount);
        journal.setAmount(amount);
        journal.setOriginalUnit(this.scheme.getCurrency());
        journal.setUnit(this.scheme.getCurrency());
        journal.setConversionRate(BigDecimal.ONE);
        return journal;
    }
}

