/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.core.CreditElement;
import kd.scmc.ccm.business.core.CreditFormula;
import kd.scmc.ccm.business.core.Dimension;
import kd.scmc.ccm.business.core.DimensionValue;
import kd.scmc.ccm.business.core.Expression;
import kd.scmc.ccm.business.core.Field;
import kd.scmc.ccm.business.core.QuotaType;
import kd.scmc.ccm.business.core.Role;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalBuilder;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.monitor.Monitor;
import kd.scmc.ccm.business.plugin.ICreditPlugin;
import kd.scmc.ccm.business.scheme.CreditScheme;
import kd.scmc.ccm.business.setting.DimensionEntryFieldMapper;
import kd.scmc.ccm.business.setting.EntityConfig;
import kd.scmc.ccm.business.valuegetter.DimensionValueGetter;
import kd.scmc.ccm.business.valuegetter.ValueGetter;
import kd.scmc.ccm.common.helper.CacheableExchangeRateLoader;
import kd.scmc.ccm.common.util.CompositeKey;

public class RuleBasedJournalBuilder
implements JournalBuilder {
    private CreditScheme scheme;
    private CreditContext context;
    private CacheableExchangeRateLoader rateLoader = new CacheableExchangeRateLoader();
    private DimensionValueGetter dimensionValueGetter;
    private Date rateDate = new Date();
    private int targetAmtprecision = 10;
    private Map<Long, DynamicObject> currencyMap = new HashMap<Long, DynamicObject>(16);

    public RuleBasedJournalBuilder(CreditScheme scheme, CreditContext context) {
        this.scheme = scheme;
        this.context = context;
        this.dimensionValueGetter = new DimensionValueGetter(scheme, context);
    }

    @Override
    public List<JournalGroup> buildJournals(List<DynamicObject> bills) {
        this.targetAmtprecision = this.scheme.getCurrencyPrecision();
        LinkedList<JournalGroup> journalGroups = new LinkedList<JournalGroup>();
        for (DynamicObject bill : bills) {
            JournalGroup journalGroup = this.buildJournals(bill);
            this.groupBy(journalGroup);
            journalGroups.add(journalGroup);
        }
        return journalGroups;
    }

    public JournalGroup buildJournals(DynamicObject bill) {
        JournalGroup journalGroup = new JournalGroup();
        journalGroup.setScheme(this.scheme);
        DynamicObjectType dt = bill.getDynamicObjectType();
        journalGroup.setBillNo(dt.getProperty("billno") != null ? bill.getString("billno") : String.valueOf(bill.getPkValue()));
        journalGroup.setMainBillId(bill.getLong("id"));
        journalGroup.setMainEntityKey(this.context.getEntityKey());
        ArrayList<Journal> journals = new ArrayList<Journal>();
        journalGroup.setJournals(journals);
        ICreditPlugin plugin = this.scheme.getPlugin(this.context);
        if (!plugin.isBillMatch(bill)) {
            Monitor.getDebugDetail(this.scheme).info(this.getClass(), "isBillMatch()=false");
            return journalGroup;
        }
        EntityConfig config = this.scheme.getEntityConfig(this.context);
        String entryKey = this.getEntryKey(config);
        if (entryKey == null) {
            Journal journal;
            Expression expression = this.matchExpressionByBill(bill);
            if (expression != null && (journal = this.createJournal(bill, null, expression)) != null) {
                journals.add(journal);
            }
        } else {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject row : entry) {
                Journal journal;
                if (!plugin.isRowMatch(row)) {
                    Monitor.getDebugDetail(this.scheme).info(this.getClass(), "EntryID=", row.getString("id"), ":isEntryMatch()=false");
                    continue;
                }
                Expression expression = this.matchExpressionByRow(row);
                if (expression == null || (journal = this.createJournal(bill, row, expression)) == null) continue;
                journals.add(journal);
            }
        }
        return journalGroup;
    }

    private Journal createJournal(DynamicObject bill, DynamicObject row, Expression expression) {
        Field orgField;
        Object orgObj;
        EntityConfig entityConfig = this.scheme.getEntityConfig(this.context);
        Journal journal = new Journal();
        journal.setMainBillId(bill.getLong("id"));
        journal.setMainEntityKey(this.context.getEntityKey());
        journal.setScheme(this.scheme);
        DynamicObjectType dt = bill.getDynamicObjectType();
        journal.setBillNo(dt.getProperty("billno") != null ? bill.getString("billno") : String.valueOf(bill.getPkValue()));
        journal.setBillId(bill.getLong("id"));
        journal.setAction(this.context.getCreditAction());
        journal.setDirection(expression.getDirection().name());
        journal.setOp(this.context.getOperateKey());
        journal.setEntityKey(bill.getDataEntityType().getName());
        if (row != null) {
            journal.setEntryKey(row.getDataEntityType().getName());
            journal.setEntryId(row.getLong("id"));
        }
        if ((orgObj = this.getValue(bill, row, orgField = entityConfig.getOrgField(), this.getValueGetter(this.scheme, CreditElement.ELEMENT_ORG))) instanceof DynamicObject) {
            journal.setOrg(((DynamicObject)orgObj).getLong("id"));
        } else {
            journal.setOrg((Long)orgObj);
        }
        QuotaType quotaType = this.scheme.getQuotaType();
        ValueGetter quotaValueGetter = expression.getValueGetter();
        journal.setQuotaType(quotaType.getQuotaType());
        BigDecimal originalQuota = BigDecimal.ZERO;
        originalQuota = row != null ? (BigDecimal)quotaValueGetter.get(row) : (BigDecimal)quotaValueGetter.get(bill);
        DimensionValue dimensionValue = null;
        dimensionValue = row != null ? (DimensionValue)this.dimensionValueGetter.get(row) : (DimensionValue)this.dimensionValueGetter.get(bill);
        journal.setDimensionValue(dimensionValue);
        journal.setOriginalAmount(originalQuota);
        if ("amount".equals(quotaType.getQuotaType()) || "privilegeamt".equals(quotaType.getQuotaType())) {
            DynamicObject srcCurrencyDO;
            if (originalQuota.compareTo(BigDecimal.ZERO) == 0) {
                return null;
            }
            Field currencyField = entityConfig.getCurrencyField();
            ValueGetter currencyValueGetter = this.getValueGetter(this.scheme, CreditElement.ELEMENT_CURRENCY);
            Object currencyObj = this.getValue(bill, row, currencyField, currencyValueGetter);
            long currency = 0L;
            currency = currencyObj instanceof DynamicObject ? ((DynamicObject)currencyObj).getLong("id") : ((Long)currencyObj).longValue();
            int srcCurAmtPrecision = 10;
            if (currency > 0L && (srcCurrencyDO = this.getAmtPrecisionAndCacheCurrencyMap(currency)) != null) {
                srcCurAmtPrecision = srcCurrencyDO.getInt("amtprecision");
                journal.setOriginalUnitPrecision(srcCurAmtPrecision);
                journal.setOriginalAmount(originalQuota.setScale(srcCurAmtPrecision, 4));
            }
            journal.setOriginalUnit(currency);
            journal.setUnit(this.scheme.getCurrency());
            journal.setUnitPrecision(this.targetAmtprecision);
            BigDecimal exchangeRate = this.getRate(currency, this.scheme.getCurrency(), this.scheme.getExchangeRateTable(), this.rateDate);
            journal.setConversionRate(exchangeRate);
            BigDecimal quota = originalQuota.multiply(exchangeRate).setScale(this.targetAmtprecision, 4);
            journal.setAmount(quota);
        } else if ("qty".equals(quotaType.getQuotaType())) {
            Dimension dimension = this.scheme.getDimension();
            List<Role> roles = dimension.getRoles();
            Map<Role, Object> valueMap = dimensionValue.getValueMap();
            DimensionEntryFieldMapper mapper = new DimensionEntryFieldMapper(dimension.getId());
            List<String> fieldTypeKeys = mapper.getFieldTypeKeys();
            for (int i = 0; i < roles.size(); ++i) {
                if (!"bd_material".equals(mapper.getBaseDataKey(fieldTypeKeys.get(i)))) continue;
                Object materialId = valueMap.get(roles.get(i));
                DynamicObject material = QueryServiceHelper.queryOne((String)"bd_material", (String)"baseunit", (QFilter[])new QFilter[]{new QFilter("id", "=", materialId)});
                journal.setUnit(material.getLong("baseunit"));
                break;
            }
            journal.setAmount(originalQuota);
        } else {
            journal.setAmount(originalQuota);
        }
        return journal;
    }

    private void groupBy(JournalGroup journalGroup) {
        List<Journal> journals = journalGroup.getJournals();
        HashMap<CompositeKey, Journal> journalMap = new HashMap<CompositeKey, Journal>();
        for (Journal journal : journals) {
            CompositeKey compositeKey = new CompositeKey(new Object[0]);
            compositeKey.addKey((Object)journal.getOrg());
            compositeKey.addKey((Object)journal.getDimensionValue());
            compositeKey.addKey((Object)journal.getOriginalUnit());
            compositeKey.addKey((Object)journal.getQuotaType());
            compositeKey.addKey((Object)journal.getConversionRate());
            Journal journal3 = (Journal)journalMap.get(compositeKey);
            if (journal3 != null) {
                journal3.setOriginalAmount(journal3.getOriginalAmount().add(journal.getOriginalAmount()));
                journal3.setAmount(journal3.getAmount().add(journal.getAmount()));
                continue;
            }
            journalMap.put(compositeKey, journal);
        }
        QuotaType quotaType = this.scheme.getQuotaType();
        if ("amount".equals(quotaType.getQuotaType()) || "privilegeamt".equals(quotaType.getQuotaType())) {
            for (Journal groupJournal : journalMap.values()) {
                DynamicObject srcCurrencyDO;
                long srcCurrencyID = groupJournal.getOriginalUnit();
                int srcCurAmtPrecision = 10;
                if (srcCurrencyID > 0L && (srcCurrencyDO = this.getAmtPrecisionAndCacheCurrencyMap(srcCurrencyID)) != null) {
                    srcCurAmtPrecision = srcCurrencyDO.getInt("amtprecision");
                    groupJournal.setOriginalAmount(groupJournal.getOriginalAmount().setScale(srcCurAmtPrecision, 4));
                }
                groupJournal.setAmount(groupJournal.getAmount().setScale(this.targetAmtprecision, 4));
            }
        }
        journalGroup.setJournals(new LinkedList<Journal>(journalMap.values()));
    }

    private String getEntryKey(EntityConfig entityConfig) {
        Field orgField = entityConfig.getOrgField();
        if (orgField.getEntryKey() != null) {
            return orgField.getEntryKey();
        }
        Field currencyField = entityConfig.getCurrencyField();
        if (currencyField.getEntryKey() != null) {
            return currencyField.getEntryKey();
        }
        Map<String, Field> creditRolesKeyMap = entityConfig.getCreditRolesKeyMap();
        for (Role role : this.scheme.getDimension().getRoles()) {
            Field field = creditRolesKeyMap.get(role.getRoleType());
            if (field.getEntryKey() == null) continue;
            return field.getEntryKey();
        }
        List<Expression> expressions = this.scheme.getExpressions(this.context);
        for (Expression exp : expressions) {
            List<Field> refFields = exp.getCondition().getFields();
            for (Field field : refFields) {
                if (field.getEntryKey() == null) continue;
                return field.getEntryKey();
            }
            CreditFormula formula = exp.getFormula();
            if (formula == null) continue;
            refFields = formula.getFields();
            for (Field field : refFields) {
                if (field.getEntryKey() == null) continue;
                return field.getEntryKey();
            }
        }
        return null;
    }

    private Object getValue(DynamicObject bill, DynamicObject row, Field field, ValueGetter fieldValueGetter) {
        if (field.getEntryKey() != null) {
            return fieldValueGetter.get(row);
        }
        return fieldValueGetter.get(bill);
    }

    private ValueGetter getValueGetter(CreditScheme scheme2, CreditElement element) {
        return scheme2.getValueGetter(this.getContext(), element);
    }

    private Expression matchExpressionByBill(DynamicObject bill) {
        List<Expression> expressions = this.scheme.getExpressions(this.getContext());
        for (Expression exp : expressions) {
            if (!exp.getFilter().isBillMatch(bill)) continue;
            return exp;
        }
        return null;
    }

    private Expression matchExpressionByRow(DynamicObject row) {
        List<Expression> expressions = this.scheme.getExpressions(this.getContext());
        for (Expression exp : expressions) {
            if (!exp.getFilter().isRowMatch(row)) continue;
            return exp;
        }
        return null;
    }

    private BigDecimal getRate(long srcCurrencyId, long targetCurrencyId, long exchangeRateTableId, Date rateDate) {
        BigDecimal rate = this.rateLoader.getRate(srcCurrencyId, targetCurrencyId, exchangeRateTableId, rateDate);
        if (rate != null) {
            return rate;
        }
        DynamicObject srcCurrency = this.getAmtPrecisionAndCacheCurrencyMap(srcCurrencyId);
        DynamicObject targetCurrency = this.getAmtPrecisionAndCacheCurrencyMap(targetCurrencyId);
        DynamicObject exchangeRateTable = BusinessDataServiceHelper.loadSingleFromCache((Object)exchangeRateTableId, (String)"bd_exratetable");
        String srcCurrencyName = srcCurrency == null ? "" : srcCurrency.getString("name");
        String targetCurrencyName = targetCurrency == null ? "" : targetCurrency.getString("name");
        String rateTableName = exchangeRateTable == null ? "" : exchangeRateTable.getString("name");
        String message = String.format(ResManager.loadKDString((String)"\u4fe1\u7528\u989d\u5ea6\u6298\u7b97\u5931\u8d25\uff0c\u6c47\u7387\u8868\u6ca1\u6709\u7ef4\u62a4\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u539f\u5e01\u4e3a%1$s\uff0c\u76ee\u6807\u5e01\u4e3a%2$s\uff0c\u6c47\u7387\u8868\u4e3a%3$s\u3002", (String)"RuleBasedJournalBuilder_0", (String)"scmc-ccm-business", (Object[])new Object[0]), srcCurrencyName, targetCurrencyName, rateTableName);
        throw new KDBizException(message);
    }

    private DynamicObject getAmtPrecisionAndCacheCurrencyMap(long currencyId) {
        DynamicObject currencyDO = this.currencyMap.get(currencyId);
        if (currencyDO == null && (currencyDO = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"id,name,number,amtprecision")) != null) {
            this.currencyMap.put(currencyId, currencyDO);
        }
        return currencyDO;
    }

    public CreditScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(CreditScheme scheme) {
        this.scheme = scheme;
    }

    public CreditContext getContext() {
        return this.context;
    }

    public void setContext(CreditContext context) {
        this.context = context;
    }
}

