/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.log;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class CcmLogClearTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(CcmLogClearTask.class);
    private static final int MAX_COUNT = 100000;
    private static final int BATCH_COUNT = 10000;
    private static final int MAX_BATCH = 100;
    private static final int DAY_COUNT = -15;
    private static final String ccmlog_entity = "ccm_log";
    private static final String INFO = "INFO";
    private static final String ERROR = "ERROR";
    private static final String DEBUG = "DEBUG";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.clearCcmLog();
    }

    private void clearCcmLog() {
        log.info("ccm \u6e05\u7406ccm\u65e5\u5fd7\u5f00\u59cb");
        long startTimeMillis = System.currentTimeMillis();
        Calendar c1 = Calendar.getInstance();
        c1.setTimeInMillis(startTimeMillis);
        c1.add(5, -15);
        Date limitDate = c1.getTime();
        long limitTimeInMillis = c1.getTimeInMillis();
        QFilter q0 = new QFilter("id", "!=", (Object)0L);
        QFilter q1 = new QFilter("level", "=", (Object)DEBUG);
        q1.or(new QFilter("level", "=", (Object)" "));
        QFilter q2 = new QFilter("level", "=", (Object)INFO);
        q2.or(new QFilter("level", "=", (Object)ERROR));
        QFilter q3 = new QFilter("datetime", "<", (Object)limitDate);
        DynamicObjectCollection query = QueryServiceHelper.query((String)ccmlog_entity, (String)"level, datetime", (QFilter[])new QFilter[]{q0}, (String)"datetime asc");
        if (query == null || query.size() == 0) {
            return;
        }
        int size = query.size();
        ArrayList pks = new ArrayList(size);
        if (size > 100000) {
            List queryPrimaryKeys;
            int debugSize = 0;
            int otherSize = 0;
            for (DynamicObject dyn : query) {
                String level = dyn.getString("level");
                if (StringUtils.isBlank((CharSequence)level) || DEBUG.equals(level)) {
                    ++debugSize;
                    continue;
                }
                ++otherSize;
            }
            int half = 50000;
            if (debugSize > half) {
                int top = debugSize - half;
                queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)ccmlog_entity, (QFilter[])new QFilter[]{q1}, (String)"datetime asc", (int)top);
                pks.addAll(queryPrimaryKeys);
            }
            if (otherSize > half) {
                int top = otherSize - half;
                queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)ccmlog_entity, (QFilter[])new QFilter[]{q2}, (String)"datetime asc", (int)top);
                pks.addAll(queryPrimaryKeys);
            }
        } else {
            long minDateTime = 0L;
            if (query.get(0) != null && ((DynamicObject)query.get(0)).getDate("datetime") != null) {
                minDateTime = ((DynamicObject)query.get(0)).getDate("datetime").getTime();
            }
            if (minDateTime < limitTimeInMillis) {
                List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)ccmlog_entity, (QFilter[])new QFilter[]{q1, q3}, (String)"datetime asc", (int)size);
                pks.addAll(queryPrimaryKeys);
            }
        }
        if (pks != null && pks.size() > 0) {
            int pkSize = pks.size();
            if (pkSize < 10000) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ccmlog_entity), (Object[])pks.toArray());
            } else {
                int count = 0;
                ArrayList pkList = new ArrayList(pks);
                while (!pkList.isEmpty() && count < 100) {
                    ++count;
                    ArrayList subPks = new ArrayList(10000);
                    while (!pkList.isEmpty() && subPks.size() < 10000) {
                        Object pk = pkList.get(0);
                        subPks.add(pk);
                        pkList.remove(pk);
                    }
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ccmlog_entity), (Object[])subPks.toArray());
                }
            }
        }
        long endTimeMillis = System.currentTimeMillis();
        log.info("ccm \u6e05\u7406ccm\u65e5\u5fd7\u7ed3\u675f\uff0c\u8017\u65f6\uff08\u6beb\u79d2\uff09\uff1a" + (endTimeMillis - startTimeMillis));
    }
}

