/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ccm.business.log;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.ccm.business.archives.ArchiveCollection;
import kd.scmc.ccm.business.check.CheckResult;
import kd.scmc.ccm.business.core.CreditContext;
import kd.scmc.ccm.business.journal.Journal;
import kd.scmc.ccm.business.journal.JournalGroup;
import kd.scmc.ccm.business.log.CcmLogInfo;
import kd.scmc.ccm.business.scheme.CreditScheme;

public class CcmLogHelper {
    private static final Log logger = LogFactory.getLog(CcmLogHelper.class);

    public static void startCreditLogForService(DynamicObject[] bills, String opKey, String source) {
        if (bills != null && bills.length > 0) {
            try {
                DynamicObjectType dt = bills[0].getDynamicObjectType();
                String name = dt.getName();
                String billinfoProKey = dt.getProperty("billno") != null ? "billno" : "id";
                Set<String> billNoList = Arrays.stream(bills).map(bill -> bill.getString(billinfoProKey)).collect(Collectors.toSet());
                CcmLogHelper.collectBizBillNo(bills);
                CcmLogInfo logInfo = CcmLogInfo.doCreate(name, opKey, billNoList, source);
                CreditContext.get().setLogInfo(logInfo);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    public static void writeCreateSchemeLog(List<CreditScheme> usefulSchemeList) {
        try {
            if (usefulSchemeList != null && usefulSchemeList.size() > 0) {
                CcmLogInfo.collectCcmLogInfo("creditscheme", usefulSchemeList);
            } else {
                CcmLogInfo.collectCcmLogInfo(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u4fe1\u63a7\u65b9\u6848", (String)"CcmLogHelper_0", (String)"scmc-ccm-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static void writeCreateJournalLog(CreditScheme scheme, List<JournalGroup> journalGroupList) {
        try {
            boolean flag = false;
            if (scheme != null && journalGroupList != null && journalGroupList.size() > 0) {
                for (JournalGroup group : journalGroupList) {
                    List<Journal> journals = group.getJournals();
                    if (journals.size() <= 0) continue;
                    flag = true;
                    break;
                }
            }
            String schemeinfo = "";
            if (scheme != null) {
                String string = schemeinfo = scheme.getNumber() != null ? scheme.getNumber() : String.valueOf(scheme.getId());
            }
            if (flag) {
                CcmLogInfo.collectCcmLogInfo("creditjournal".concat("$$").concat(schemeinfo), journalGroupList);
            } else {
                CcmLogInfo.collectCcmLogInfo("creditjournal".concat("$$").concat(schemeinfo), ResManager.loadKDString((String)"\u5355\u636e\u7b56\u7565\u53d6\u503c\u8fc7\u7a0b\u672a\u80fd\u5339\u914d\u751f\u6210\u6d41\u6c34\u3002", (String)"CcmLogHelper_1", (String)"scmc-ccm-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static void writeArchiveBeforeLog(CreditScheme scheme, ArchiveCollection archives) {
        if (scheme != null && archives != null && archives.size() > 0) {
            String schemeinfo = scheme.getNumber() != null ? scheme.getNumber() : String.valueOf(scheme.getId());
            CcmLogInfo.collectCcmLogInfo("archive_before".concat("$$").concat(schemeinfo), archives.toString());
        }
    }

    public static void writeArchiveAfterLog(CreditScheme scheme, ArchiveCollection archives) {
        if (scheme != null && archives != null && archives.size() > 0) {
            String schemeinfo = scheme.getNumber() != null ? scheme.getNumber() : String.valueOf(scheme.getId());
            CcmLogInfo.collectCcmLogInfo("archive_after".concat("$$").concat(schemeinfo), archives.toString());
        }
    }

    public static void writeUnLockArchiveLog(List<CheckResult> unlockArchiveList) {
        if (unlockArchiveList != null && unlockArchiveList.size() > 0) {
            CcmLogInfo.collectCcmLogInfo("nogetcreditlock", unlockArchiveList);
        }
    }

    public static void writeCreditLog(List<CheckResult> resultList) {
        if (resultList.size() > 0) {
            StringBuilder resultStr = new StringBuilder();
            for (int i = 0; i < resultList.size(); ++i) {
                CheckResult result = resultList.get(i);
                boolean success = result.isSuccess();
                if (success) continue;
                String formatMsg = String.format("success:%1$s,messagetype:%2$s,message:%3$s", success, result.getMessageType(), result.getMessage());
                if (i == 0) {
                    resultStr.append(formatMsg);
                    continue;
                }
                resultStr.append("$$").append(formatMsg);
            }
            if (resultStr.length() > 0) {
                CcmLogInfo.collectCcmLogInfo(resultStr.toString());
            }
        }
        CcmLogInfo.writeCreditLog();
    }

    private static String collectBizBillNo(DynamicObject[] bills) {
        String bizBillNo = "$$";
        HashSet<String> bizBillNoList = new HashSet<String>(16);
        bizBillNoList.add(bizBillNo);
        if (bills != null && bills.length > 0) {
            DynamicObjectType dt = bills[0].getDynamicObjectType();
            for (DynamicObject bill : bills) {
                if (bill == null) continue;
                bizBillNo = dt.getProperty("billno") != null ? bills[0].getString("billno") : bills[0].getString("id");
                bizBillNoList.add(bizBillNo);
            }
        }
        return ((Object)bizBillNoList).toString();
    }

    public static void collectExpLog(Exception exp) {
        String mainExpMsg = exp.toString();
        String expMsg = mainExpMsg.concat(Arrays.toString(exp.getStackTrace()));
        CcmLogInfo.writeExpCreditLog(mainExpMsg, expMsg);
    }

    public static void collectUpdateExpResult(DynamicObject[] bills, String opKey, List<CheckResult> resultList, String mainExpMsg) {
        CheckResult result = new CheckResult(false, "error", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\uff1a%1$s \u5728\u8c03\u7528\u4fe1\u63a7\u66f4\u65b0\u65f6\u5b58\u5728\u5f02\u5e38\uff1a%2$s", (String)"CcmLogHelper_2", (String)"scmc-ccm-business", (Object[])new Object[0]), opKey, mainExpMsg));
        result.setBillno(CcmLogHelper.collectBizBillNo(bills));
        resultList.add(result);
    }
}

